/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.dto.settings.impl;

import java.util.Date;

import jp.mosp.framework.base.BaseDto;
import jp.mosp.time.dto.settings.AttendanceViewDtoInterface;

/**
 * 未承認管理詳細勤怠データDTO
 */
public class AttendanceViewDto extends BaseDto implements AttendanceViewDtoInterface {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= -8966960793882294825L;
	
	/**
	 * レコード識別ID。
	 */
	private long				tmdAttendanceId;
	/**
	 * 個人ID。
	 */
	private String				personalId;
	/**
	 * 社員コード。
	 */
	private String				employeeCode;
	/**
	 * 社員氏名(姓)。
	 */
	private String				lastName;
	/**
	 * 社員氏名(名)。
	 */
	private String				firstName;
	/**
	 * 所属コード。
	 */
	private String				sectionCode;
	/**
	 * カテゴリ。
	 */
	private String				category;
	/**
	 * 勤務日。
	 */
	private Date				workDate;
	/**
	 * 勤務回数。
	 */
	private int					timesWork;
	/**
	 * 勤務形態コード。
	 */
	private String				workTypeCode;
	/**
	 * 直行。
	 */
	private int					directStart;
	/**
	 * 直帰。
	 */
	private int					directEnd;
	/**
	 * 出勤時刻。
	 */
	private Date				startTime;
	/**
	 * 退勤時刻。
	 */
	private Date				endTime;
	/**
	 * 遅刻時間。
	 */
	private int					lateTime;
	/**
	 * 遅刻理由。
	 */
	private String				lateReason;
	/**
	 * 遅刻証明書。
	 */
	private String				lateCertificate;
	/**
	 * 遅刻コメント。
	 */
	private String				lateComment;
	/**
	 * 早退時間。
	 */
	private int					leaveEarlyTime;
	/**
	 * 早退理由。
	 */
	private String				leaveEarlyReason;
	/**
	 * 早退証明書。
	 */
	private String				leaveEarlyCertificate;
	/**
	 * 早退コメント。
	 */
	private String				leaveEarlyComment;
	/**
	 * 勤務時間。
	 */
	private int					workTime;
	/**
	 * 所定労働時間。
	 */
	private int					generalWorkTime;
	/**
	 * 休憩時間。
	 */
	private int					restTime;
	/**
	 * 法定外休憩時間。
	 */
	private int					overRestTime;
	/**
	 * 深夜休憩時間。
	 */
	private int					nightRestTime;
	/**
	 * 公用外出時間。
	 */
	private int					publicTime;
	/**
	 * 私用外出時間。
	 */
	private int					privateTime;
	/**
	 * 残業時間。
	 */
	private int					overtime;
	/**
	 * 前残業時間。
	 */
	private int					overtimeBefore;
	/**
	 * 後残業時間。
	 */
	private int					overtimeAfter;
	/**
	 * 法定内残業時間。
	 */
	private int					overtimeIn;
	/**
	 * 法定外残業時間。
	 */
	private int					overtimeOut;
	/**
	 * 深夜勤務時間。
	 */
	private int					lateNightTime;
	/**
	 * 所定休日勤務時間。
	 */
	private int					specificWorkTime;
	/**
	 * 法定休日勤務時間。
	 */
	private int					legalWorkTime;
	/**
	 * 減額対象時間。
	 */
	private int					decreaseTime;
	/**
	 * 勤怠コメント。
	 */
	private String				timeComment;
	/**
	 * ワークフロー番号。
	 */
	private long				workflow;
	/**
	 * 承認段階。
	 */
	private int					stage;
	/**
	 * 承認状況。
	 */
	private String				state;
	/**
	 * 承認者。
	 */
	private String				approverName;
	

	@Override
	public int getStage() {
		return stage;
	}
	
	@Override
	public String getState() {
		return state;
	}
	
	@Override
	public void setStage(int stage) {
		this.stage = stage;
	}
	
	@Override
	public void setState(String state) {
		this.state = state;
	}
	
	@Override
	public int getDecreaseTime() {
		return decreaseTime;
	}
	
	@Override
	public String getEmployeeCode() {
		return employeeCode;
	}
	
	@Override
	public Date getEndTime() {
		return getDateClone(endTime);
	}
	
	@Override
	public String getLateCertificate() {
		return lateCertificate;
	}
	
	@Override
	public String getLateComment() {
		return lateComment;
	}
	
	@Override
	public int getLateNightTime() {
		return lateNightTime;
	}
	
	@Override
	public String getLateReason() {
		return lateReason;
	}
	
	@Override
	public int getLateTime() {
		return lateTime;
	}
	
	@Override
	public String getLeaveEarlyCertificate() {
		return leaveEarlyCertificate;
	}
	
	@Override
	public String getLeaveEarlyComment() {
		return leaveEarlyComment;
	}
	
	@Override
	public String getLeaveEarlyReason() {
		return leaveEarlyReason;
	}
	
	@Override
	public int getLeaveEarlyTime() {
		return leaveEarlyTime;
	}
	
	@Override
	public int getLegalWorkTime() {
		return legalWorkTime;
	}
	
	@Override
	public int getNightRestTime() {
		return nightRestTime;
	}
	
	@Override
	public int getOverRestTime() {
		return overRestTime;
	}
	
	@Override
	public int getOvertime() {
		return overtime;
	}
	
	@Override
	public int getOvertimeOut() {
		return overtimeOut;
	}
	
	@Override
	public int getPrivateTime() {
		return privateTime;
	}
	
	@Override
	public int getPublicTime() {
		return publicTime;
	}
	
	@Override
	public int getRestTime() {
		return restTime;
	}
	
	@Override
	public int getSpecificWorkTime() {
		return specificWorkTime;
	}
	
	@Override
	public Date getStartTime() {
		return getDateClone(startTime);
	}
	
	@Override
	public long getTmdAttendanceId() {
		return tmdAttendanceId;
	}
	
	@Override
	public Date getWorkDate() {
		return getDateClone(workDate);
	}
	
	@Override
	public int getWorkTime() {
		return workTime;
	}
	
	@Override
	public String getWorkTypeCode() {
		return workTypeCode;
	}
	
	@Override
	public long getWorkflow() {
		return workflow;
	}
	
	@Override
	public int getTimesWork() {
		return timesWork;
	}
	
	@Override
	public String getPersonalId() {
		return personalId;
	}
	
	@Override
	public void setDecreaseTime(int decreaseTime) {
		this.decreaseTime = decreaseTime;
	}
	
	@Override
	public void setEmployeeCode(String employeeCode) {
		this.employeeCode = employeeCode;
	}
	
	@Override
	public void setEndTime(Date endTime) {
		this.endTime = getDateClone(endTime);
	}
	
	@Override
	public void setLateCertificate(String lateCertificate) {
		this.lateCertificate = lateCertificate;
	}
	
	@Override
	public void setLateComment(String lateComment) {
		this.lateComment = lateComment;
	}
	
	@Override
	public void setLateNightTime(int lateNightTime) {
		this.lateNightTime = lateNightTime;
	}
	
	@Override
	public void setLateReason(String lateReason) {
		this.lateReason = lateReason;
	}
	
	@Override
	public void setLateTime(int lateTime) {
		this.lateTime = lateTime;
	}
	
	@Override
	public void setLeaveEarlyCertificate(String leaveEarlyCertificate) {
		this.leaveEarlyCertificate = leaveEarlyCertificate;
	}
	
	@Override
	public void setLeaveEarlyComment(String leaveEarlyComment) {
		this.leaveEarlyComment = leaveEarlyComment;
	}
	
	@Override
	public void setLeaveEarlyReason(String leaveEarlyReason) {
		this.leaveEarlyReason = leaveEarlyReason;
	}
	
	@Override
	public void setLeaveEarlyTime(int leaveEarlyTime) {
		this.leaveEarlyTime = leaveEarlyTime;
	}
	
	@Override
	public void setLegalWorkTime(int legalWorkTime) {
		this.legalWorkTime = legalWorkTime;
	}
	
	@Override
	public void setNightRestTime(int nightRestTime) {
		this.nightRestTime = nightRestTime;
	}
	
	@Override
	public void setOverRestTime(int overRestTime) {
		this.overRestTime = overRestTime;
	}
	
	@Override
	public void setOvertime(int overtime) {
		this.overtime = overtime;
	}
	
	@Override
	public void setOvertimeOut(int overtimeOut) {
		this.overtimeOut = overtimeOut;
	}
	
	@Override
	public void setPrivateTime(int privateTime) {
		this.privateTime = privateTime;
	}
	
	@Override
	public void setPublicTime(int publicTime) {
		this.publicTime = publicTime;
	}
	
	@Override
	public void setRestTime(int restTime) {
		this.restTime = restTime;
	}
	
	@Override
	public void setSpecificWorkTime(int specificWorkTime) {
		this.specificWorkTime = specificWorkTime;
	}
	
	@Override
	public void setStartTime(Date startTime) {
		this.startTime = getDateClone(startTime);
	}
	
	@Override
	public void setTmdAttendanceId(long tmdAttendanceId) {
		this.tmdAttendanceId = tmdAttendanceId;
	}
	
	@Override
	public void setWorkDate(Date workDate) {
		this.workDate = getDateClone(workDate);
	}
	
	@Override
	public void setTimesWork(int timesWork) {
		this.timesWork = timesWork;
	}
	
	@Override
	public void setWorkTypeCode(String workTypeCode) {
		this.workTypeCode = workTypeCode;
	}
	
	@Override
	public void setWorkflow(long workflow) {
		this.workflow = workflow;
	}
	
	@Override
	public void setWorkTime(int workTime) {
		this.workTime = workTime;
	}
	
	@Override
	public String getFirstName() {
		return firstName;
	}
	
	@Override
	public String getLastName() {
		return lastName;
	}
	
	@Override
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	
	@Override
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	@Override
	public String getSectionCode() {
		return sectionCode;
	}
	
	@Override
	public void setSectionCode(String sectionCode) {
		this.sectionCode = sectionCode;
	}
	
	@Override
	public String getCategory() {
		return category;
	}
	
	@Override
	public void setCategory(String category) {
		this.category = category;
	}
	
	@Override
	public String getApproverName() {
		return approverName;
	}
	
	@Override
	public void setApproverName(String approverName) {
		this.approverName = approverName;
	}
	
	@Override
	public void setPersonalId(String personalId) {
		this.personalId = personalId;
	}
	
	@Override
	public String getTimeComment() {
		return timeComment;
	}
	
	@Override
	public void setTimeComment(String timeComment) {
		this.timeComment = timeComment;
	}
	
	@Override
	public int getDirectEnd() {
		return directEnd;
	}
	
	@Override
	public int getDirectStart() {
		return directStart;
	}
	
	@Override
	public void setDirectEnd(int directEnd) {
		this.directEnd = directEnd;
	}
	
	@Override
	public void setDirectStart(int directStart) {
		this.directStart = directStart;
	}
	
	@Override
	public int getGeneralWorkTime() {
		return generalWorkTime;
	}
	
	@Override
	public int getOvertimeIn() {
		return overtimeIn;
	}
	
	@Override
	public void setGeneralWorkTime(int generalWorkTime) {
		this.generalWorkTime = generalWorkTime;
	}
	
	@Override
	public void setOvertimeIn(int overtimeIn) {
		this.overtimeIn = overtimeIn;
	}
	
	@Override
	public int getOvertimeAfter() {
		return overtimeAfter;
	}
	
	@Override
	public int getOvertimeBefore() {
		return overtimeBefore;
	}
	
	@Override
	public void setOvertimeAfter(int overtimeAfter) {
		this.overtimeAfter = overtimeAfter;
	}
	
	@Override
	public void setOvertimeBefore(int overtimeBefore) {
		this.overtimeBefore = overtimeBefore;
	}
}
