/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.settings.vo;

import jp.mosp.time.constant.TimeConst;
import jp.mosp.time.settings.base.TimeSettingVo;

/**
 * 勤務形態情報の情報を格納する。
 */
public class WorkTypeCardVo extends TimeSettingVo {
	
	private static final long	serialVersionUID	= -6430605613779135771L;
	
	private String				txtWorkTypeCode;
	private String				txtWorkTypeName;
	private String				txtWorkTypeAbbr;
	private String				txtWorkStartHour;
	private String				txtWorkStartMinute;
	private String				txtWorkEndHour;
	private String				txtWorkEndMinute;
	private String				txtRestTimeHour;
	private String				txtRestTimeMinute;
	private String				txtWorkTimeHour;
	private String				txtWorkTimeMinute;
	private String				txtRestStart1Hour;
	private String				txtRestStart1Minute;
	private String				txtRestEnd1Hour;
	private String				txtRestEnd1Minute;
	private String				txtRestStart2Hour;
	private String				txtRestStart2Minute;
	private String				txtRestEnd2Hour;
	private String				txtRestEnd2Minute;
	private String				txtRestStart3Hour;
	private String				txtRestStart3Minute;
	private String				txtRestEnd3Hour;
	private String				txtRestEnd3Minute;
	private String				txtRestStart4Hour;
	private String				txtRestStart4Minute;
	private String				txtRestEnd4Hour;
	private String				txtRestEnd4Minute;
	private String				txtFrontStartHour;
	private String				txtFrontStartMinute;
	private String				txtFrontEndHour;
	private String				txtFrontEndMinute;
	private String				txtBackStartHour;
	private String				txtBackStartMinute;
	private String				txtBackEndHour;
	private String				txtBackEndMinute;
	private String				txtOverBeforeHour;
	private String				txtOverBeforeMinute;
	private String				txtOverPerHour;
	private String				txtOverPerMinute;
	private String				txtOverRestHour;
	private String				txtOverRestMinute;
	private String				txtHalfRestHour;
	private String				txtHalfRestMinute;
	private String				txtHalfRestStartHour;
	private String				txtHalfRestStartMinute;
	private String				txtHalfRestEndHour;
	private String				txtHalfRestEndMinute;
	private String				lblWorkTime;
	private String				lblRestTime;
	
	private String[]			aryItem				= { TimeConst.CODE_WORKSTART, TimeConst.CODE_WORKEND,
		TimeConst.CODE_WORKTIME, TimeConst.CODE_RESTTIME, TimeConst.CODE_RESTSTART1, TimeConst.CODE_RESTEND1,
		TimeConst.CODE_RESTSTART2, TimeConst.CODE_RESTEND2, TimeConst.CODE_RESTSTART3, TimeConst.CODE_RESTEND3,
		TimeConst.CODE_RESTSTART4, TimeConst.CODE_RESTEND4, TimeConst.CODE_FRONTSTART, TimeConst.CODE_FRONTEND,
		TimeConst.CODE_BACKSTART, TimeConst.CODE_BACKEND, TimeConst.CODE_OVERBEFORE, TimeConst.CODE_OVERPER,
		TimeConst.CODE_OVERREST, TimeConst.CODE_HALFREST, TimeConst.CODE_HALFRESTSTART, TimeConst.CODE_HALFRESTEND };
	
	private long[]				tmmWorkTypeItemId;
	

	/**
	 * @return txtWorkTypeCode
	 */
	public String getTxtWorkTypeCode() {
		return txtWorkTypeCode;
	}
	
	/**
	 * @param txtWorkTypeCode セットする txtWorkTypeCode
	 */
	public void setTxtWorkTypeCode(String txtWorkTypeCode) {
		this.txtWorkTypeCode = txtWorkTypeCode;
	}
	
	/**
	 * @return txtWorkTypeName
	 */
	public String getTxtWorkTypeName() {
		return txtWorkTypeName;
	}
	
	/**
	 * @param txtWorkTypeName セットする txtWorkTypeName
	 */
	public void setTxtWorkTypeName(String txtWorkTypeName) {
		this.txtWorkTypeName = txtWorkTypeName;
	}
	
	/**
	 * @return txtWorkTypeAbbr
	 */
	public String getTxtWorkTypeAbbr() {
		return txtWorkTypeAbbr;
	}
	
	/**
	 * @param txtWorkTypeAbbr セットする txtWorkTypeAbbr
	 */
	public void setTxtWorkTypeAbbr(String txtWorkTypeAbbr) {
		this.txtWorkTypeAbbr = txtWorkTypeAbbr;
	}
	
	/**
	 * @return txtWorkStartHour
	 */
	public String getTxtWorkStartHour() {
		return txtWorkStartHour;
	}
	
	/**
	 * @param txtWorkStartHour セットする txtWorkStartHour
	 */
	public void setTxtWorkStartHour(String txtWorkStartHour) {
		this.txtWorkStartHour = txtWorkStartHour;
	}
	
	/**
	 * @return txtWorkStartMinute
	 */
	public String getTxtWorkStartMinute() {
		return txtWorkStartMinute;
	}
	
	/**
	 * @param txtWorkStartMinute セットする txtWorkStartMinute
	 */
	public void setTxtWorkStartMinute(String txtWorkStartMinute) {
		this.txtWorkStartMinute = txtWorkStartMinute;
	}
	
	/**
	 * @return txtWorkEndHour
	 */
	public String getTxtWorkEndHour() {
		return txtWorkEndHour;
	}
	
	/**
	 * @param txtWorkEndHour セットする txtWorkEndHour
	 */
	public void setTxtWorkEndHour(String txtWorkEndHour) {
		this.txtWorkEndHour = txtWorkEndHour;
	}
	
	/**
	 * @return txtWorkEndMinute
	 */
	public String getTxtWorkEndMinute() {
		return txtWorkEndMinute;
	}
	
	/**
	 * @param txtWorkEndMinute セットする txtWorkEndMinute
	 */
	public void setTxtWorkEndMinute(String txtWorkEndMinute) {
		this.txtWorkEndMinute = txtWorkEndMinute;
	}
	
	/**
	 * @return txtRestTimeHour
	 */
	public String getTxtRestTimeHour() {
		return txtRestTimeHour;
	}
	
	/**
	 * @param txtRestTimeHour セットする txtRestTimeHour
	 */
	public void setTxtRestTimeHour(String txtRestTimeHour) {
		this.txtRestTimeHour = txtRestTimeHour;
	}
	
	/**
	 * @return txtRestTimeMinute
	 */
	public String getTxtRestTimeMinute() {
		return txtRestTimeMinute;
	}
	
	/**
	 * @param txtRestTimeMinute セットする txtRestTimeMinute
	 */
	public void setTxtRestTimeMinute(String txtRestTimeMinute) {
		this.txtRestTimeMinute = txtRestTimeMinute;
	}
	
	/**
	 * @return txtWorkTimeHour
	 */
	public String getTxtWorkTimeHour() {
		return txtWorkTimeHour;
	}
	
	/**
	 * @param txtWorkTimeHour セットする txtWorkTimeHour
	 */
	public void setTxtWorkTimeHour(String txtWorkTimeHour) {
		this.txtWorkTimeHour = txtWorkTimeHour;
	}
	
	/**
	 * @return txtWorkTimeMinute
	 */
	public String getTxtWorkTimeMinute() {
		return txtWorkTimeMinute;
	}
	
	/**
	 * @param txtWorkTimeMinute セットする txtWorkTimeMinute
	 */
	public void setTxtWorkTimeMinute(String txtWorkTimeMinute) {
		this.txtWorkTimeMinute = txtWorkTimeMinute;
	}
	
	/**
	 * @return txtRestStart1Hour
	 */
	public String getTxtRestStart1Hour() {
		return txtRestStart1Hour;
	}
	
	/**
	 * @param txtRestStart1Hour セットする txtRestStart1Hour
	 */
	public void setTxtRestStart1Hour(String txtRestStart1Hour) {
		this.txtRestStart1Hour = txtRestStart1Hour;
	}
	
	/**
	 * @return txtRestStart1Minute
	 */
	public String getTxtRestStart1Minute() {
		return txtRestStart1Minute;
	}
	
	/**
	 * @param txtRestStart1Minute セットする txtRestStart1Minute
	 */
	public void setTxtRestStart1Minute(String txtRestStart1Minute) {
		this.txtRestStart1Minute = txtRestStart1Minute;
	}
	
	/**
	 * @return txtRestEnd1Hour
	 */
	public String getTxtRestEnd1Hour() {
		return txtRestEnd1Hour;
	}
	
	/**
	 * @param txtRestEnd1Hour セットする txtRestEnd1Hour
	 */
	public void setTxtRestEnd1Hour(String txtRestEnd1Hour) {
		this.txtRestEnd1Hour = txtRestEnd1Hour;
	}
	
	/**
	 * @return txtRestEnd1Minute
	 */
	public String getTxtRestEnd1Minute() {
		return txtRestEnd1Minute;
	}
	
	/**
	 * @param txtRestEnd1Minute セットする txtRestEnd1Minute
	 */
	public void setTxtRestEnd1Minute(String txtRestEnd1Minute) {
		this.txtRestEnd1Minute = txtRestEnd1Minute;
	}
	
	/**
	 * @return txtRestStart2Hour
	 */
	public String getTxtRestStart2Hour() {
		return txtRestStart2Hour;
	}
	
	/**
	 * @param txtRestStart2Hour セットする txtRestStart2Hour
	 */
	public void setTxtRestStart2Hour(String txtRestStart2Hour) {
		this.txtRestStart2Hour = txtRestStart2Hour;
	}
	
	/**
	 * @return txtRestStart2Minute
	 */
	public String getTxtRestStart2Minute() {
		return txtRestStart2Minute;
	}
	
	/**
	 * @param txtRestStart2Minute セットする txtRestStart2Minute
	 */
	public void setTxtRestStart2Minute(String txtRestStart2Minute) {
		this.txtRestStart2Minute = txtRestStart2Minute;
	}
	
	/**
	 * @return txtRestEnd2Hour
	 */
	public String getTxtRestEnd2Hour() {
		return txtRestEnd2Hour;
	}
	
	/**
	 * @param txtRestEnd2Hour セットする txtRestEnd2Hour
	 */
	public void setTxtRestEnd2Hour(String txtRestEnd2Hour) {
		this.txtRestEnd2Hour = txtRestEnd2Hour;
	}
	
	/**
	 * @return txtRestEnd2Minute
	 */
	public String getTxtRestEnd2Minute() {
		return txtRestEnd2Minute;
	}
	
	/**
	 * @param txtRestEnd2Minute セットする txtRestEnd2Minute
	 */
	public void setTxtRestEnd2Minute(String txtRestEnd2Minute) {
		this.txtRestEnd2Minute = txtRestEnd2Minute;
	}
	
	/**
	 * @return txtRestStart3Hour
	 */
	public String getTxtRestStart3Hour() {
		return txtRestStart3Hour;
	}
	
	/**
	 * @param txtRestStart3Hour セットする txtRestStart3Hour
	 */
	public void setTxtRestStart3Hour(String txtRestStart3Hour) {
		this.txtRestStart3Hour = txtRestStart3Hour;
	}
	
	/**
	 * @return txtRestStart3Minute
	 */
	public String getTxtRestStart3Minute() {
		return txtRestStart3Minute;
	}
	
	/**
	 * @param txtRestStart3Minute セットする txtRestStart3Minute
	 */
	public void setTxtRestStart3Minute(String txtRestStart3Minute) {
		this.txtRestStart3Minute = txtRestStart3Minute;
	}
	
	/**
	 * @return txtRestEnd3Hour
	 */
	public String getTxtRestEnd3Hour() {
		return txtRestEnd3Hour;
	}
	
	/**
	 * @param txtRestEnd3Hour セットする txtRestEnd3Hour
	 */
	public void setTxtRestEnd3Hour(String txtRestEnd3Hour) {
		this.txtRestEnd3Hour = txtRestEnd3Hour;
	}
	
	/**
	 * @return txtRestEnd3Minute
	 */
	public String getTxtRestEnd3Minute() {
		return txtRestEnd3Minute;
	}
	
	/**
	 * @param txtRestEnd3Minute セットする txtRestEnd3Minute
	 */
	public void setTxtRestEnd3Minute(String txtRestEnd3Minute) {
		this.txtRestEnd3Minute = txtRestEnd3Minute;
	}
	
	/**
	 * @return txtRestStart4Hour
	 */
	public String getTxtRestStart4Hour() {
		return txtRestStart4Hour;
	}
	
	/**
	 * @param txtRestStart4Hour セットする txtRestStart4Hour
	 */
	public void setTxtRestStart4Hour(String txtRestStart4Hour) {
		this.txtRestStart4Hour = txtRestStart4Hour;
	}
	
	/**
	 * @return txtRestStart4Minute
	 */
	public String getTxtRestStart4Minute() {
		return txtRestStart4Minute;
	}
	
	/**
	 * @param txtRestStart4Minute セットする txtRestStart4Minute
	 */
	public void setTxtRestStart4Minute(String txtRestStart4Minute) {
		this.txtRestStart4Minute = txtRestStart4Minute;
	}
	
	/**
	 * @return txtRestEnd4Hour
	 */
	public String getTxtRestEnd4Hour() {
		return txtRestEnd4Hour;
	}
	
	/**
	 * @param txtRestEnd4Hour セットする txtRestEnd4Hour
	 */
	public void setTxtRestEnd4Hour(String txtRestEnd4Hour) {
		this.txtRestEnd4Hour = txtRestEnd4Hour;
	}
	
	/**
	 * @return txtRestEnd4Minute
	 */
	public String getTxtRestEnd4Minute() {
		return txtRestEnd4Minute;
	}
	
	/**
	 * @param txtRestEnd4Minute セットする txtRestEnd4Minute
	 */
	public void setTxtRestEnd4Minute(String txtRestEnd4Minute) {
		this.txtRestEnd4Minute = txtRestEnd4Minute;
	}
	
	/**
	 * @return txtFrontStartHour
	 */
	public String getTxtFrontStartHour() {
		return txtFrontStartHour;
	}
	
	/**
	 * @param txtFrontStartHour セットする txtFrontStartHour
	 */
	public void setTxtFrontStartHour(String txtFrontStartHour) {
		this.txtFrontStartHour = txtFrontStartHour;
	}
	
	/**
	 * @return txtFrontStartMinute
	 */
	public String getTxtFrontStartMinute() {
		return txtFrontStartMinute;
	}
	
	/**
	 * @param txtFrontStartMinute セットする txtFrontStartMinute
	 */
	public void setTxtFrontStartMinute(String txtFrontStartMinute) {
		this.txtFrontStartMinute = txtFrontStartMinute;
	}
	
	/**
	 * @return txtFrontEndHour
	 */
	public String getTxtFrontEndHour() {
		return txtFrontEndHour;
	}
	
	/**
	 * @param txtFrontEndHour セットする txtFrontEndHour
	 */
	public void setTxtFrontEndHour(String txtFrontEndHour) {
		this.txtFrontEndHour = txtFrontEndHour;
	}
	
	/**
	 * @return txtFrontEndMinute
	 */
	public String getTxtFrontEndMinute() {
		return txtFrontEndMinute;
	}
	
	/**
	 * @param txtFrontEndMinute セットする txtFrontEndMinute
	 */
	public void setTxtFrontEndMinute(String txtFrontEndMinute) {
		this.txtFrontEndMinute = txtFrontEndMinute;
	}
	
	/**
	 * @return txtBackStartHour
	 */
	public String getTxtBackStartHour() {
		return txtBackStartHour;
	}
	
	/**
	 * @param txtBackStartHour セットする txtBackStartHour
	 */
	public void setTxtBackStartHour(String txtBackStartHour) {
		this.txtBackStartHour = txtBackStartHour;
	}
	
	/**
	 * @return txtBackStartMinute
	 */
	public String getTxtBackStartMinute() {
		return txtBackStartMinute;
	}
	
	/**
	 * @param txtBackStartMinute セットする txtBackStartMinute
	 */
	public void setTxtBackStartMinute(String txtBackStartMinute) {
		this.txtBackStartMinute = txtBackStartMinute;
	}
	
	/**
	 * @return txtBackEndHour
	 */
	public String getTxtBackEndHour() {
		return txtBackEndHour;
	}
	
	/**
	 * @param txtBackEndHour セットする txtBackEndHour
	 */
	public void setTxtBackEndHour(String txtBackEndHour) {
		this.txtBackEndHour = txtBackEndHour;
	}
	
	/**
	 * @return txtBackEndMinute
	 */
	public String getTxtBackEndMinute() {
		return txtBackEndMinute;
	}
	
	/**
	 * @param txtBackEndMinute セットする txtBackEndMinute
	 */
	public void setTxtBackEndMinute(String txtBackEndMinute) {
		this.txtBackEndMinute = txtBackEndMinute;
	}
	
	/**
	 * @return txtOverBeforeHour
	 */
	public String getTxtOverBeforeHour() {
		return txtOverBeforeHour;
	}
	
	/**
	 * @param txtOverBeforeHour セットする txtOverBeforeHour
	 */
	public void setTxtOverBeforeHour(String txtOverBeforeHour) {
		this.txtOverBeforeHour = txtOverBeforeHour;
	}
	
	/**
	 * @return txtOverBeforeMinute
	 */
	public String getTxtOverBeforeMinute() {
		return txtOverBeforeMinute;
	}
	
	/**
	 * @param txtOverBeforeMinute セットする txtOverBeforeMinute
	 */
	public void setTxtOverBeforeMinute(String txtOverBeforeMinute) {
		this.txtOverBeforeMinute = txtOverBeforeMinute;
	}
	
	/**
	 * @return txtOverPerHour
	 */
	public String getTxtOverPerHour() {
		return txtOverPerHour;
	}
	
	/**
	 * @param txtOverPerHour セットする txtOverPerHour
	 */
	public void setTxtOverPerHour(String txtOverPerHour) {
		this.txtOverPerHour = txtOverPerHour;
	}
	
	/**
	 * @return txtOverPerMinute
	 */
	public String getTxtOverPerMinute() {
		return txtOverPerMinute;
	}
	
	/**
	 * @param txtOverPerMinute セットする txtOverPerMinute
	 */
	public void setTxtOverPerMinute(String txtOverPerMinute) {
		this.txtOverPerMinute = txtOverPerMinute;
	}
	
	/**
	 * @return txtOverRestHour
	 */
	public String getTxtOverRestHour() {
		return txtOverRestHour;
	}
	
	/**
	 * @param txtOverRestHour セットする txtOverRestHour
	 */
	public void setTxtOverRestHour(String txtOverRestHour) {
		this.txtOverRestHour = txtOverRestHour;
	}
	
	/**
	 * @return txtOverRestMinute
	 */
	public String getTxtOverRestMinute() {
		return txtOverRestMinute;
	}
	
	/**
	 * @param txtOverRestMinute セットする txtOverRestMinute
	 */
	public void setTxtOverRestMinute(String txtOverRestMinute) {
		this.txtOverRestMinute = txtOverRestMinute;
	}
	
	/**
	 * @return txtHalfRestHour
	 */
	public String getTxtHalfRestHour() {
		return txtHalfRestHour;
	}
	
	/**
	 * @param txtHalfRestHour セットする txtHalfRestHour
	 */
	public void setTxtHalfRestHour(String txtHalfRestHour) {
		this.txtHalfRestHour = txtHalfRestHour;
	}
	
	/**
	 * @return txtHalfRestMinute
	 */
	public String getTxtHalfRestMinute() {
		return txtHalfRestMinute;
	}
	
	/**
	 * @param txtHalfRestMinute セットする txtHalfRestMinute
	 */
	public void setTxtHalfRestMinute(String txtHalfRestMinute) {
		this.txtHalfRestMinute = txtHalfRestMinute;
	}
	
	/**
	 * @return txtHalfRestStartHour
	 */
	public String getTxtHalfRestStartHour() {
		return txtHalfRestStartHour;
	}
	
	/**
	 * @param txtHalfRestStartHour セットする txtHalfRestStartHour
	 */
	public void setTxtHalfRestStartHour(String txtHalfRestStartHour) {
		this.txtHalfRestStartHour = txtHalfRestStartHour;
	}
	
	/**
	 * @return txtHalfRestStartMinute
	 */
	public String getTxtHalfRestStartMinute() {
		return txtHalfRestStartMinute;
	}
	
	/**
	 * @param txtHalfRestStartMinute セットする txtHalfRestStartMinute
	 */
	public void setTxtHalfRestStartMinute(String txtHalfRestStartMinute) {
		this.txtHalfRestStartMinute = txtHalfRestStartMinute;
	}
	
	/**
	 * @return txtHalfRestEndHour
	 */
	public String getTxtHalfRestEndHour() {
		return txtHalfRestEndHour;
	}
	
	/**
	 * @param txtHalfRestEndHour セットする txtHalfRestEndHour
	 */
	public void setTxtHalfRestEndHour(String txtHalfRestEndHour) {
		this.txtHalfRestEndHour = txtHalfRestEndHour;
	}
	
	/**
	 * @return txtHalfRestEndMinute
	 */
	public String getTxtHalfRestEndMinute() {
		return txtHalfRestEndMinute;
	}
	
	/**
	 * @param txtHalfRestEndMinute セットする txtHalfRestEndMinute
	 */
	public void setTxtHalfRestEndMinute(String txtHalfRestEndMinute) {
		this.txtHalfRestEndMinute = txtHalfRestEndMinute;
	}
	
	/**
	 * @return lblWorkTime
	 */
	public String getLblWorkTime() {
		return lblWorkTime;
	}
	
	/**
	 * @param lblWorkTime セットする lblWoekTime
	 */
	public void setLblWorkTime(String lblWorkTime) {
		this.lblWorkTime = lblWorkTime;
	}
	
	/**
	 * @return lblRestTime
	 */
	public String getLblRestTime() {
		return lblRestTime;
	}
	
	/**
	 * @param lblRestTime セットする lblRestTime
	 */
	public void setLblRestTime(String lblRestTime) {
		this.lblRestTime = lblRestTime;
	}
	
	/**
	 * @return aryItem
	 */
	public String[] getAryItem() {
		return getStringArrayClone(aryItem);
	}
	
	/**
	 * @param aryItem セットする aryItem
	 */
	public void setAryItem(String[] aryItem) {
		this.aryItem = getStringArrayClone(aryItem);
	}
	
	/**
	 * @param i レコード識別IDのIndex
	 * @return tmmWorkTypeItemId
	 */
	public long getTmmWorkTypeItemId(int i) {
		return tmmWorkTypeItemId[i];
	}
	
	/**
	 * @param tmmWorkTypeItemId セットする tmmWorkTypeItemId
	 * @param i レコード識別IDのIndex
	 */
	public void setTmmWorkTypeItemId(long tmmWorkTypeItemId, int i) {
		this.tmmWorkTypeItemId[i] = tmmWorkTypeItemId;
	}
	
	/**
	 * @param tmmWorkTypeItemId セットする tmmWorkTypeItemId
	 */
	public void setTmmWorkTypeItemId(long[] tmmWorkTypeItemId) {
		this.tmmWorkTypeItemId = getLongArrayClone(tmmWorkTypeItemId);
	}
	
}
