/*
 * Created on 2004/09/21
 */
package jp.sourceforge.mrsp;

import jp.sourceforge.mrsp.model.Artifact;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

/**
 * @author Ryuzo Yamamoto
 * @version $Id: ArtifactViewerSorter.java,v 1.2 2004/09/22 01:35:14 dragon3 Exp $
 */
public class ArtifactViewerSorter extends ViewerSorter {

    public static final int GROUPID = 1;

    public static final int ARTIFACTID = 2;

    public static final int VERSION = 3;

    public static final int TYPE = 4;

    public static final int REPOSITORY = 5;

    private int creteria;

    /**
     * 
     * @param criteria
     */
    public ArtifactViewerSorter(int criteria) {
        super();
        this.creteria = criteria;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ViewerSorter#compare(org.eclipse.jface.viewers.Viewer,
     *      java.lang.Object, java.lang.Object)
     */
    public int compare(Viewer viewer, Object e1, Object e2) {

        Artifact artifact_1 = (Artifact) e1;
        Artifact artifact_2 = (Artifact) e2;

        switch (creteria) {
        case 1:
            return compareGroupId(artifact_1, artifact_2);
        case 2:
            return compareArtifactId(artifact_1, artifact_2);
        case 3:
            return compareVersion(artifact_1, artifact_2);
        case 4:
            return compareType(artifact_1, artifact_2);
        case 5:
            return compareRepository(artifact_1, artifact_2);
        default:
            break;
        }
        return super.compare(viewer, e1, e2);
    }

    protected int compareGroupId(Artifact artifact_1, Artifact artifact_2) {
        return collator.compare(artifact_1.getGroupId(), artifact_2
                .getGroupId());
    }

    protected int compareArtifactId(Artifact artifact_1, Artifact artifact_2) {
        return collator.compare(artifact_1.getArtifactId(), artifact_2
                .getArtifactId());
    }

    protected int compareVersion(Artifact artifact_1, Artifact artifact_2) {
        return collator.compare(artifact_1.getVersion(), artifact_2
                .getVersion());
    }

    protected int compareType(Artifact artifact_1, Artifact artifact_2) {
        return collator.compare(artifact_1.getType(), artifact_2.getType());
    }

    protected int compareRepository(Artifact artifact_1, Artifact artifact_2) {
        return collator.compare(artifact_1.getRepoUrl(), artifact_2
                .getRepoUrl());
    }
}