/*
 * Created on 2004/09/18
 */
package jp.sourceforge.mrsp.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.mrsp.model.Artifact;

/**
 * @author Ryuzo Yamamoto
 * @version $Id: HtmlParser.java,v 1.3 2004/09/21 16:04:44 dragon3 Exp $
 */
public class HtmlParser implements ResponseParser {

    private static final Pattern artifactPattern = Pattern
            .compile(
                    "<tr[^>]*>[\\s]*<td>([^<]*)</td>[\\s]*<td>([^<]*)</td>[\\s]*<td>([^<]*)</td>[\\s]*<td>([^<]*)</td>[\\s]*<td>(ibiblio|<a href=\"[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+\">[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+</a>)</td>[\\s]*</tr>",
                    Pattern.MULTILINE);

    private static final Pattern repoUrlPattern = Pattern
            .compile("s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+");

    /*
     * (non-Javadoc)
     * 
     * @see jp.loveopium.eclipse.mrs.parser.ContentParser#parse(java.lang.Object)
     */
    public List parse(Object o) {
        String s = (String) o;
        List list = new ArrayList();

        Matcher matcher = artifactPattern.matcher(s);

        while (matcher.find()) {
            Artifact artifact = new Artifact();
            artifact.setGroupId(matcher.group(1));
            artifact.setArtifactId(matcher.group(2));
            artifact.setVersion(matcher.group(3));
            artifact.setType(matcher.group(4));

            if (matcher.group(5).equals("ibiblio")) {
                artifact.setRepoUrl("http://www.ibiblio.org/maven/");
            } else {
                Matcher repoUrlMatcher = repoUrlPattern.matcher(matcher
                        .group(5));
                if (repoUrlMatcher.find()) {
                    artifact.setRepoUrl(repoUrlMatcher.group(0));
                }
            }
            list.add(artifact);
        }
        return list;
    }

}