/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mrsp.model;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.mrsp.ResultListener;
import jp.sourceforge.mrsp.model.Artifact;
import org.eclipse.jface.util.ListenerList;

public class Result {
    private List artifacts;
    private ListenerList listenerList = new ListenerList();

    public Result() {
        this.artifacts = new ArrayList();
    }

    public List getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List artifacts) {
        this.artifacts = artifacts;
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        int n = listeners.length;
        while (i < n) {
            ResultListener resultListener = (ResultListener)listeners[i];
            resultListener.artifactsUpdated(this);
            ++i;
        }
    }

    private void addArtifact(Artifact artifact) {
        this.artifacts.add(artifact);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        int n = listeners.length;
        while (i < n) {
            ResultListener resultListener = (ResultListener)listeners[i];
            resultListener.artifactAdded(artifact);
            ++i;
        }
    }

    private void removeArtifact(Artifact artifact) {
        this.artifacts.remove(artifact);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        int n = listeners.length;
        while (i < n) {
            ResultListener resultListener = (ResultListener)listeners[i];
            resultListener.artifactRemoved(artifact);
            ++i;
        }
    }

    public void addResultListener(ResultListener resultListener) {
        this.listenerList.add((Object)resultListener);
    }

    public void removeResultLister(ResultListener resultListener) {
        this.listenerList.remove((Object)resultListener);
    }
}

