/*
 * Created on 2004/09/18
 */
package jp.sourceforge.mrsp;

import jp.sourceforge.mrsp.model.Artifact;
import jp.sourceforge.mrsp.model.Result;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

/**
 * @author Ryuzo Yamamoto
 * @version $Id: ResultContentProvider.java,v 1.1 2004/09/20 10:49:16 yamamoto
 *          Exp $
 */
public class ResultContentProvider implements IStructuredContentProvider,
        ResultListener {

    private TableViewer viewer;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    public Object[] getElements(Object inputElement) {
        return ((Result) inputElement).getArtifacts().toArray();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.loveopium.eclipse.mrs.ResultListener#artifactAdded(jp.loveopium.eclipse.mrs.model.Artifact)
     */
    public void artifactAdded(final Artifact artifact) {
        if (viewer != null) {
            Control control = viewer.getControl();
            if ((control != null) && !(control.isDisposed())) {
                control.getDisplay().syncExec(new Runnable() {
                    public void run() {
                        viewer.add(artifact);
                    }
                });
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.loveopium.eclipse.mavenreposearch.ResultListener#artifactRemoved(jp.loveopium.eclipse.mavenreposearch.model.Artifact)
     */
    public void artifactRemoved(final Artifact artifact) {
        if (viewer != null) {
            Control control = viewer.getControl();
            if ((control != null) && !(control.isDisposed())) {
                control.getDisplay().syncExec(new Runnable() {
                    public void run() {
                        viewer.remove(artifact);
                    }
                });
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.sourceforge.mrsp.ResultListener#artifactsUpdate(java.util.List)
     */
    public void artifactsUpdated(final Result result) {
        if (viewer != null) {
            Control control = viewer.getControl();
            if ((control != null) && !(control.isDisposed())) {
                control.getDisplay().syncExec(new Runnable() {
                    public void run() {
                        viewer.setInput(result);
                    }
                });
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IContentProvider#dispose()
     */
    public void dispose() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
     *      java.lang.Object, java.lang.Object)
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer) viewer;
        if (oldInput != null) {
            ((Result) oldInput).removeResultLister(this);
        }
        if (newInput != null) {
            ((Result) newInput).addResultListener(this);
        }
    }

}