/*
 * Created on 2004/09/23
 */
package jp.sourceforge.mrsp.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @author Ryuzo Yamamoto
 * @version $Id: XMLResponseParser.java,v 1.1 2004/09/23 06:42:14 dragon3 Exp $
 */
public class XMLResponseParser implements ResponseParser {

    private static SAXParserFactory factory;

    /*
     * (non-Javadoc)
     * 
     * @see jp.sourceforge.mrsp.parser.ResponseParser#parse(java.lang.Object)
     */
    public List parse(Object o) throws ParseException {
        String s = (String) o;
        try {
            SAXParser parser = getParser();
            DefaultHandler handler = getHandler();
            parser.parse(new InputSource(new StringReader(s)), handler);
            return ((ArtifactsHandler) handler).getArtifacts();

        } catch (ParserConfigurationException e) {
            throw new ParseException(e);

        } catch (SAXException e) {
            throw new ParseException(e);

        } catch (IOException e) {
            throw new ParseException(e);
        }
    }

    private SAXParser getParser() throws ParserConfigurationException,
            SAXException {
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
        }
        return factory.newSAXParser();
    }

    private DefaultHandler getHandler() {
        return new ArtifactsHandler();
    }
}