//
// MessagePack for C++ static resolution routine
//
// Copyright (C) 2008-2009 FURUHASHI Sadayuki
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//
#ifndef MSGPACK_TYPE_TUPLE_HPP__
#define MSGPACK_TYPE_TUPLE_HPP__

#include "msgpack/object.hpp"

namespace msgpack {

namespace type {

// FIXME operator==
// FIXME operator!=


template <typename A0 = void, typename A1 = void, typename A2 = void, typename A3 = void, typename A4 = void, typename A5 = void, typename A6 = void, typename A7 = void, typename A8 = void, typename A9 = void, typename A10 = void, typename A11 = void, typename A12 = void, typename A13 = void, typename A14 = void, typename A15 = void, typename A16 = void, typename A17 = void, typename A18 = void, typename A19 = void, typename A20 = void, typename A21 = void, typename A22 = void, typename A23 = void, typename A24 = void, typename A25 = void, typename A26 = void, typename A27 = void, typename A28 = void, typename A29 = void, typename A30 = void, typename A31 = void, typename A32 = void>
struct tuple;

template <typename Tuple, int N>
struct tuple_element;

template <typename Tuple, int N>
struct const_tuple_element;

template <typename T>
struct tuple_type {
	typedef T type;
	typedef T value_type;
	typedef T& reference;
	typedef const T& const_reference;
	typedef const T& transparent_reference;
};

template <typename T>
struct tuple_type<T&> {
	typedef T type;
	typedef T& value_type;
	typedef T& reference;
	typedef const T& const_reference;
	typedef T& transparent_reference;
};

template <typename T>
struct tuple_type<const T&> {
	typedef T type;
	typedef T& value_type;
	typedef T& reference;
	typedef const T& const_reference;
	typedef const T& transparent_reference;
};



template <typename A0>
struct tuple_element<tuple<A0>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0>& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};



template <typename A0, typename A1>
struct tuple_element<tuple<A0, A1>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1>
struct tuple_element<tuple<A0, A1>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};



template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 24> : tuple_type<A24> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : _x(x.a24) {}
	typename tuple_type<A24>::reference get() { return _x; }
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 24> : tuple_type<A24> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a24) {}
	typename tuple_type<A24>::reference get() { return _x; }
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 25> : tuple_type<A25> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : _x(x.a25) {}
	typename tuple_type<A25>::reference get() { return _x; }
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 24> : tuple_type<A24> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a24) {}
	typename tuple_type<A24>::reference get() { return _x; }
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 25> : tuple_type<A25> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a25) {}
	typename tuple_type<A25>::reference get() { return _x; }
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 26> : tuple_type<A26> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : _x(x.a26) {}
	typename tuple_type<A26>::reference get() { return _x; }
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 24> : tuple_type<A24> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a24) {}
	typename tuple_type<A24>::reference get() { return _x; }
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 25> : tuple_type<A25> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a25) {}
	typename tuple_type<A25>::reference get() { return _x; }
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 26> : tuple_type<A26> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a26) {}
	typename tuple_type<A26>::reference get() { return _x; }
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 27> : tuple_type<A27> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : _x(x.a27) {}
	typename tuple_type<A27>::reference get() { return _x; }
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 24> : tuple_type<A24> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a24) {}
	typename tuple_type<A24>::reference get() { return _x; }
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 25> : tuple_type<A25> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a25) {}
	typename tuple_type<A25>::reference get() { return _x; }
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 26> : tuple_type<A26> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a26) {}
	typename tuple_type<A26>::reference get() { return _x; }
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 27> : tuple_type<A27> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a27) {}
	typename tuple_type<A27>::reference get() { return _x; }
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 28> : tuple_type<A28> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : _x(x.a28) {}
	typename tuple_type<A28>::reference get() { return _x; }
	typename tuple_type<A28>::const_reference get() const { return _x; }
private:
	typename tuple_type<A28>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 24> : tuple_type<A24> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a24) {}
	typename tuple_type<A24>::reference get() { return _x; }
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 25> : tuple_type<A25> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a25) {}
	typename tuple_type<A25>::reference get() { return _x; }
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 26> : tuple_type<A26> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a26) {}
	typename tuple_type<A26>::reference get() { return _x; }
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 27> : tuple_type<A27> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a27) {}
	typename tuple_type<A27>::reference get() { return _x; }
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 28> : tuple_type<A28> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a28) {}
	typename tuple_type<A28>::reference get() { return _x; }
	typename tuple_type<A28>::const_reference get() const { return _x; }
private:
	typename tuple_type<A28>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 29> : tuple_type<A29> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : _x(x.a29) {}
	typename tuple_type<A29>::reference get() { return _x; }
	typename tuple_type<A29>::const_reference get() const { return _x; }
private:
	typename tuple_type<A29>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 24> : tuple_type<A24> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a24) {}
	typename tuple_type<A24>::reference get() { return _x; }
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 25> : tuple_type<A25> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a25) {}
	typename tuple_type<A25>::reference get() { return _x; }
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 26> : tuple_type<A26> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a26) {}
	typename tuple_type<A26>::reference get() { return _x; }
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 27> : tuple_type<A27> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a27) {}
	typename tuple_type<A27>::reference get() { return _x; }
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 28> : tuple_type<A28> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a28) {}
	typename tuple_type<A28>::reference get() { return _x; }
	typename tuple_type<A28>::const_reference get() const { return _x; }
private:
	typename tuple_type<A28>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 29> : tuple_type<A29> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a29) {}
	typename tuple_type<A29>::reference get() { return _x; }
	typename tuple_type<A29>::const_reference get() const { return _x; }
private:
	typename tuple_type<A29>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 30> : tuple_type<A30> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : _x(x.a30) {}
	typename tuple_type<A30>::reference get() { return _x; }
	typename tuple_type<A30>::const_reference get() const { return _x; }
private:
	typename tuple_type<A30>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 16> : tuple_type<A16> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a16) {}
	typename tuple_type<A16>::reference get() { return _x; }
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 17> : tuple_type<A17> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a17) {}
	typename tuple_type<A17>::reference get() { return _x; }
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 18> : tuple_type<A18> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a18) {}
	typename tuple_type<A18>::reference get() { return _x; }
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 19> : tuple_type<A19> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a19) {}
	typename tuple_type<A19>::reference get() { return _x; }
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 20> : tuple_type<A20> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a20) {}
	typename tuple_type<A20>::reference get() { return _x; }
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 21> : tuple_type<A21> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a21) {}
	typename tuple_type<A21>::reference get() { return _x; }
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 22> : tuple_type<A22> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a22) {}
	typename tuple_type<A22>::reference get() { return _x; }
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 23> : tuple_type<A23> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a23) {}
	typename tuple_type<A23>::reference get() { return _x; }
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 24> : tuple_type<A24> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a24) {}
	typename tuple_type<A24>::reference get() { return _x; }
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 25> : tuple_type<A25> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a25) {}
	typename tuple_type<A25>::reference get() { return _x; }
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 26> : tuple_type<A26> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a26) {}
	typename tuple_type<A26>::reference get() { return _x; }
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 27> : tuple_type<A27> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a27) {}
	typename tuple_type<A27>::reference get() { return _x; }
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 28> : tuple_type<A28> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a28) {}
	typename tuple_type<A28>::reference get() { return _x; }
	typename tuple_type<A28>::const_reference get() const { return _x; }
private:
	typename tuple_type<A28>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 29> : tuple_type<A29> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a29) {}
	typename tuple_type<A29>::reference get() { return _x; }
	typename tuple_type<A29>::const_reference get() const { return _x; }
private:
	typename tuple_type<A29>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 30> : tuple_type<A30> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a30) {}
	typename tuple_type<A30>::reference get() { return _x; }
	typename tuple_type<A30>::const_reference get() const { return _x; }
private:
	typename tuple_type<A30>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 31> : tuple_type<A31> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : _x(x.a31) {}
	typename tuple_type<A31>::reference get() { return _x; }
	typename tuple_type<A31>::const_reference get() const { return _x; }
private:
	typename tuple_type<A31>::reference _x;
};





template <typename A0>
struct const_tuple_element<tuple<A0>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};



template <typename A0, typename A1>
struct const_tuple_element<tuple<A0, A1>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1>
struct const_tuple_element<tuple<A0, A1>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};



template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 24> : tuple_type<A24> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : _x(x.a24) {}
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 24> : tuple_type<A24> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a24) {}
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 25> : tuple_type<A25> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : _x(x.a25) {}
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 24> : tuple_type<A24> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a24) {}
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 25> : tuple_type<A25> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a25) {}
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 26> : tuple_type<A26> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : _x(x.a26) {}
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 24> : tuple_type<A24> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a24) {}
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 25> : tuple_type<A25> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a25) {}
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 26> : tuple_type<A26> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a26) {}
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 27> : tuple_type<A27> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : _x(x.a27) {}
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 24> : tuple_type<A24> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a24) {}
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 25> : tuple_type<A25> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a25) {}
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 26> : tuple_type<A26> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a26) {}
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 27> : tuple_type<A27> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a27) {}
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 28> : tuple_type<A28> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : _x(x.a28) {}
	typename tuple_type<A28>::const_reference get() const { return _x; }
private:
	typename tuple_type<A28>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 24> : tuple_type<A24> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a24) {}
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 25> : tuple_type<A25> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a25) {}
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 26> : tuple_type<A26> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a26) {}
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 27> : tuple_type<A27> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a27) {}
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 28> : tuple_type<A28> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a28) {}
	typename tuple_type<A28>::const_reference get() const { return _x; }
private:
	typename tuple_type<A28>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 29> : tuple_type<A29> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : _x(x.a29) {}
	typename tuple_type<A29>::const_reference get() const { return _x; }
private:
	typename tuple_type<A29>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 24> : tuple_type<A24> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a24) {}
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 25> : tuple_type<A25> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a25) {}
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 26> : tuple_type<A26> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a26) {}
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 27> : tuple_type<A27> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a27) {}
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 28> : tuple_type<A28> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a28) {}
	typename tuple_type<A28>::const_reference get() const { return _x; }
private:
	typename tuple_type<A28>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 29> : tuple_type<A29> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a29) {}
	typename tuple_type<A29>::const_reference get() const { return _x; }
private:
	typename tuple_type<A29>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 30> : tuple_type<A30> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : _x(x.a30) {}
	typename tuple_type<A30>::const_reference get() const { return _x; }
private:
	typename tuple_type<A30>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 16> : tuple_type<A16> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a16) {}
	typename tuple_type<A16>::const_reference get() const { return _x; }
private:
	typename tuple_type<A16>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 17> : tuple_type<A17> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a17) {}
	typename tuple_type<A17>::const_reference get() const { return _x; }
private:
	typename tuple_type<A17>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 18> : tuple_type<A18> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a18) {}
	typename tuple_type<A18>::const_reference get() const { return _x; }
private:
	typename tuple_type<A18>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 19> : tuple_type<A19> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a19) {}
	typename tuple_type<A19>::const_reference get() const { return _x; }
private:
	typename tuple_type<A19>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 20> : tuple_type<A20> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a20) {}
	typename tuple_type<A20>::const_reference get() const { return _x; }
private:
	typename tuple_type<A20>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 21> : tuple_type<A21> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a21) {}
	typename tuple_type<A21>::const_reference get() const { return _x; }
private:
	typename tuple_type<A21>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 22> : tuple_type<A22> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a22) {}
	typename tuple_type<A22>::const_reference get() const { return _x; }
private:
	typename tuple_type<A22>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 23> : tuple_type<A23> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a23) {}
	typename tuple_type<A23>::const_reference get() const { return _x; }
private:
	typename tuple_type<A23>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 24> : tuple_type<A24> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a24) {}
	typename tuple_type<A24>::const_reference get() const { return _x; }
private:
	typename tuple_type<A24>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 25> : tuple_type<A25> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a25) {}
	typename tuple_type<A25>::const_reference get() const { return _x; }
private:
	typename tuple_type<A25>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 26> : tuple_type<A26> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a26) {}
	typename tuple_type<A26>::const_reference get() const { return _x; }
private:
	typename tuple_type<A26>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 27> : tuple_type<A27> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a27) {}
	typename tuple_type<A27>::const_reference get() const { return _x; }
private:
	typename tuple_type<A27>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 28> : tuple_type<A28> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a28) {}
	typename tuple_type<A28>::const_reference get() const { return _x; }
private:
	typename tuple_type<A28>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 29> : tuple_type<A29> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a29) {}
	typename tuple_type<A29>::const_reference get() const { return _x; }
private:
	typename tuple_type<A29>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 30> : tuple_type<A30> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a30) {}
	typename tuple_type<A30>::const_reference get() const { return _x; }
private:
	typename tuple_type<A30>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 31> : tuple_type<A31> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : _x(x.a31) {}
	typename tuple_type<A31>::const_reference get() const { return _x; }
private:
	typename tuple_type<A31>::const_reference _x;
};



template <>
struct tuple<> {
	tuple() {}
	tuple(object o) { o.convert(this); }
	typedef tuple<> value_type;
};

template <typename A0>
struct tuple<A0> {
	typedef tuple<A0> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0) :
		a0(_a0) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
};

template <typename A0, typename A1>
struct tuple<A0, A1> {
	typedef tuple<A0, A1> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1) :
		a0(_a0), a1(_a1) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
};

template <typename A0, typename A1, typename A2>
struct tuple<A0, A1, A2> {
	typedef tuple<A0, A1, A2> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2) :
		a0(_a0), a1(_a1), a2(_a2) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple<A0, A1, A2, A3> {
	typedef tuple<A0, A1, A2, A3> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple<A0, A1, A2, A3, A4> {
	typedef tuple<A0, A1, A2, A3, A4> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple<A0, A1, A2, A3, A4, A5> {
	typedef tuple<A0, A1, A2, A3, A4, A5> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple<A0, A1, A2, A3, A4, A5, A6> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
	A24 a24;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
	A24 a24;
	A25 a25;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
	A24 a24;
	A25 a25;
	A26 a26;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
	A24 a24;
	A25 a25;
	A26 a26;
	A27 a27;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27, typename tuple_type<A28>::transparent_reference _a28) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27), a28(_a28) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
	A24 a24;
	A25 a25;
	A26 a26;
	A27 a27;
	A28 a28;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27, typename tuple_type<A28>::transparent_reference _a28, typename tuple_type<A29>::transparent_reference _a29) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27), a28(_a28), a29(_a29) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
	A24 a24;
	A25 a25;
	A26 a26;
	A27 a27;
	A28 a28;
	A29 a29;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27, typename tuple_type<A28>::transparent_reference _a28, typename tuple_type<A29>::transparent_reference _a29, typename tuple_type<A30>::transparent_reference _a30) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27), a28(_a28), a29(_a29), a30(_a30) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
	A24 a24;
	A25 a25;
	A26 a26;
	A27 a27;
	A28 a28;
	A29 a29;
	A30 a30;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27, typename tuple_type<A28>::transparent_reference _a28, typename tuple_type<A29>::transparent_reference _a29, typename tuple_type<A30>::transparent_reference _a30, typename tuple_type<A31>::transparent_reference _a31) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27), a28(_a28), a29(_a29), a30(_a30), a31(_a31) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
	A16 a16;
	A17 a17;
	A18 a18;
	A19 a19;
	A20 a20;
	A21 a21;
	A22 a22;
	A23 a23;
	A24 a24;
	A25 a25;
	A26 a26;
	A27 a27;
	A28 a28;
	A29 a29;
	A30 a30;
	A31 a31;
};


inline tuple<> make_tuple()
{
	return tuple<>();
}

template <typename A0>
tuple<A0> make_tuple(typename tuple_type<A0>::transparent_reference a0)
{
	return tuple<A0>(a0);
}

template <typename A0, typename A1>
tuple<A0, A1> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1)
{
	return tuple<A0, A1>(a0, a1);
}

template <typename A0, typename A1, typename A2>
tuple<A0, A1, A2> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2)
{
	return tuple<A0, A1, A2>(a0, a1, a2);
}

template <typename A0, typename A1, typename A2, typename A3>
tuple<A0, A1, A2, A3> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3)
{
	return tuple<A0, A1, A2, A3>(a0, a1, a2, a3);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4>
tuple<A0, A1, A2, A3, A4> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4)
{
	return tuple<A0, A1, A2, A3, A4>(a0, a1, a2, a3, a4);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
tuple<A0, A1, A2, A3, A4, A5> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5)
{
	return tuple<A0, A1, A2, A3, A4, A5>(a0, a1, a2, a3, a4, a5);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
tuple<A0, A1, A2, A3, A4, A5, A6> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6>(a0, a1, a2, a3, a4, a5, a6);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
tuple<A0, A1, A2, A3, A4, A5, A6, A7> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7>(a0, a1, a2, a3, a4, a5, a6, a7);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>(a0, a1, a2, a3, a4, a5, a6, a7, a8);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27, typename tuple_type<A28>::transparent_reference a28)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27, typename tuple_type<A28>::transparent_reference a28, typename tuple_type<A29>::transparent_reference a29)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27, typename tuple_type<A28>::transparent_reference a28, typename tuple_type<A29>::transparent_reference a29, typename tuple_type<A30>::transparent_reference a30)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27, typename tuple_type<A28>::transparent_reference a28, typename tuple_type<A29>::transparent_reference a29, typename tuple_type<A30>::transparent_reference a30, typename tuple_type<A31>::transparent_reference a31)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31);
}


}  // namespace type


inline type::tuple<>& operator>> (
		object o,
		type::tuple<>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	return v;
}

template <typename A0>
type::tuple<A0>& operator>> (
		object o,
		type::tuple<A0>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 1) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	return v;
}

template <typename A0, typename A1>
type::tuple<A0, A1>& operator>> (
		object o,
		type::tuple<A0, A1>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 2) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	return v;
}

template <typename A0, typename A1, typename A2>
type::tuple<A0, A1, A2>& operator>> (
		object o,
		type::tuple<A0, A1, A2>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 3) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3>
type::tuple<A0, A1, A2, A3>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 4) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4>
type::tuple<A0, A1, A2, A3, A4>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 5) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
type::tuple<A0, A1, A2, A3, A4, A5>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 6) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
type::tuple<A0, A1, A2, A3, A4, A5, A6>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 7) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 8) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 9) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 10) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 11) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 12) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 13) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 14) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 15) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 16) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 17) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 18) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 19) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 20) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 21) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 22) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 23) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 24) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 25) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	o.via.array.ptr[24].convert<A24>(&v.template get<24>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 26) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	o.via.array.ptr[24].convert<A24>(&v.template get<24>());
	o.via.array.ptr[25].convert<A25>(&v.template get<25>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 27) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	o.via.array.ptr[24].convert<A24>(&v.template get<24>());
	o.via.array.ptr[25].convert<A25>(&v.template get<25>());
	o.via.array.ptr[26].convert<A26>(&v.template get<26>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 28) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	o.via.array.ptr[24].convert<A24>(&v.template get<24>());
	o.via.array.ptr[25].convert<A25>(&v.template get<25>());
	o.via.array.ptr[26].convert<A26>(&v.template get<26>());
	o.via.array.ptr[27].convert<A27>(&v.template get<27>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 29) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	o.via.array.ptr[24].convert<A24>(&v.template get<24>());
	o.via.array.ptr[25].convert<A25>(&v.template get<25>());
	o.via.array.ptr[26].convert<A26>(&v.template get<26>());
	o.via.array.ptr[27].convert<A27>(&v.template get<27>());
	o.via.array.ptr[28].convert<A28>(&v.template get<28>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 30) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	o.via.array.ptr[24].convert<A24>(&v.template get<24>());
	o.via.array.ptr[25].convert<A25>(&v.template get<25>());
	o.via.array.ptr[26].convert<A26>(&v.template get<26>());
	o.via.array.ptr[27].convert<A27>(&v.template get<27>());
	o.via.array.ptr[28].convert<A28>(&v.template get<28>());
	o.via.array.ptr[29].convert<A29>(&v.template get<29>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 31) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	o.via.array.ptr[24].convert<A24>(&v.template get<24>());
	o.via.array.ptr[25].convert<A25>(&v.template get<25>());
	o.via.array.ptr[26].convert<A26>(&v.template get<26>());
	o.via.array.ptr[27].convert<A27>(&v.template get<27>());
	o.via.array.ptr[28].convert<A28>(&v.template get<28>());
	o.via.array.ptr[29].convert<A29>(&v.template get<29>());
	o.via.array.ptr[30].convert<A30>(&v.template get<30>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 32) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	o.via.array.ptr[16].convert<A16>(&v.template get<16>());
	o.via.array.ptr[17].convert<A17>(&v.template get<17>());
	o.via.array.ptr[18].convert<A18>(&v.template get<18>());
	o.via.array.ptr[19].convert<A19>(&v.template get<19>());
	o.via.array.ptr[20].convert<A20>(&v.template get<20>());
	o.via.array.ptr[21].convert<A21>(&v.template get<21>());
	o.via.array.ptr[22].convert<A22>(&v.template get<22>());
	o.via.array.ptr[23].convert<A23>(&v.template get<23>());
	o.via.array.ptr[24].convert<A24>(&v.template get<24>());
	o.via.array.ptr[25].convert<A25>(&v.template get<25>());
	o.via.array.ptr[26].convert<A26>(&v.template get<26>());
	o.via.array.ptr[27].convert<A27>(&v.template get<27>());
	o.via.array.ptr[28].convert<A28>(&v.template get<28>());
	o.via.array.ptr[29].convert<A29>(&v.template get<29>());
	o.via.array.ptr[30].convert<A30>(&v.template get<30>());
	o.via.array.ptr[31].convert<A31>(&v.template get<31>());
	return v;
}


template <typename Stream>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<>& v) {
	o.pack_array(0);
	return o;
}

template <typename Stream, typename A0>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0>& v) {
	o.pack_array(1);
	
	o.pack(v.template get<0>());
	return o;
}

template <typename Stream, typename A0, typename A1>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1>& v) {
	o.pack_array(2);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2>& v) {
	o.pack_array(3);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3>& v) {
	o.pack_array(4);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4>& v) {
	o.pack_array(5);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5>& v) {
	o.pack_array(6);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6>& v) {
	o.pack_array(7);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>& v) {
	o.pack_array(8);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& v) {
	o.pack_array(9);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& v) {
	o.pack_array(10);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& v) {
	o.pack_array(11);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& v) {
	o.pack_array(12);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& v) {
	o.pack_array(13);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& v) {
	o.pack_array(14);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& v) {
	o.pack_array(15);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& v) {
	o.pack_array(16);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& v) {
	o.pack_array(17);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& v) {
	o.pack_array(18);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& v) {
	o.pack_array(19);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& v) {
	o.pack_array(20);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& v) {
	o.pack_array(21);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& v) {
	o.pack_array(22);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& v) {
	o.pack_array(23);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& v) {
	o.pack_array(24);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& v) {
	o.pack_array(25);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	o.pack(v.template get<24>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& v) {
	o.pack_array(26);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	o.pack(v.template get<24>());
	o.pack(v.template get<25>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& v) {
	o.pack_array(27);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	o.pack(v.template get<24>());
	o.pack(v.template get<25>());
	o.pack(v.template get<26>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& v) {
	o.pack_array(28);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	o.pack(v.template get<24>());
	o.pack(v.template get<25>());
	o.pack(v.template get<26>());
	o.pack(v.template get<27>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& v) {
	o.pack_array(29);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	o.pack(v.template get<24>());
	o.pack(v.template get<25>());
	o.pack(v.template get<26>());
	o.pack(v.template get<27>());
	o.pack(v.template get<28>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& v) {
	o.pack_array(30);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	o.pack(v.template get<24>());
	o.pack(v.template get<25>());
	o.pack(v.template get<26>());
	o.pack(v.template get<27>());
	o.pack(v.template get<28>());
	o.pack(v.template get<29>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& v) {
	o.pack_array(31);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	o.pack(v.template get<24>());
	o.pack(v.template get<25>());
	o.pack(v.template get<26>());
	o.pack(v.template get<27>());
	o.pack(v.template get<28>());
	o.pack(v.template get<29>());
	o.pack(v.template get<30>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& v) {
	o.pack_array(32);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	o.pack(v.template get<16>());
	o.pack(v.template get<17>());
	o.pack(v.template get<18>());
	o.pack(v.template get<19>());
	o.pack(v.template get<20>());
	o.pack(v.template get<21>());
	o.pack(v.template get<22>());
	o.pack(v.template get<23>());
	o.pack(v.template get<24>());
	o.pack(v.template get<25>());
	o.pack(v.template get<26>());
	o.pack(v.template get<27>());
	o.pack(v.template get<28>());
	o.pack(v.template get<29>());
	o.pack(v.template get<30>());
	o.pack(v.template get<31>());
	return o;
}


}  // namespace msgpack

#endif /* msgpack/type/tuple.hpp */

