function fixSpaces(string) {
	if (string.charAt(0) == " ") string = nbsp + string.slice(1);
	return string.
		replace(/[ \u00a0]{2,}/g, function(s) {return makeWhiteSpace(s.length);});
}

(function() {
	function asEditorLines(string) {
		var tab = makeWhiteSpace(indentUnit);
		return map(string.replace(/\u00a0/g, " ").replace(/\r\n?/g, "\n").split("\n"), fixSpaces);
	}

	Editor.prototype.importCode = function(code) {
		this.history.push(null, null, asEditorLines(code));
		this.history.reset();
	};

    Editor.prototype.insertIntoLine = function(line, position, content) {
		var before = null;
		if (position == "end") {
			before = endOfLine(line, this.container);
		}
		else {
			for (var cur = line ? line.nextSibling : this.container.firstChild; cur; cur = cur.nextSibling) {
				if (position == 0) {
					before = cur;
					break;
				}
				var text = (cur.innerText || cur.textContent || cur.nodeValue || "");
				if (text.length > position) {
					before = cur.nextSibling;
					content = text.slice(0, position) + content + text.slice(position);
					removeElement(cur);
					break;
				}
				position -= text.length;
			}
		}

		var lines = asEditorLines(content), doc = this.container.ownerDocument;
		for (var i = 0; i < lines.length; i++) {
			if (i > 0) this.container.insertBefore(doc.createElement("BR"), before);
			this.container.insertBefore(makePartSpan(lines[i], doc), before);
		}
		this.addDirtyNode(line);
		this.scheduleHighlight();
	};

    Editor.prototype.replaceRange = function(from, to, text) {
		var lines = asEditorLines(text);
		lines[0] = this.history.textAfter(from.node).slice(0, from.offset) + lines[0];
		var lastLine = lines[lines.length - 1];
		lines[lines.length - 1] = lastLine + this.history.textAfter(to.node).slice(to.offset);
		var end = this.history.nodeAfter(to.node);
		this.history.push(from.node, end, lines);
		return {node: this.history.nodeBefore(end),
			offset: lastLine.length};
    };
})();
