# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

package Bleach::App;
use strict;
use warnings;

use Encode;

sub _hdlr_bleach {
	my ($ctx, $args, $cond) = @_;

	my $text = '';
	my $texts = $ctx->stash('tokens')->getElementsByTagName('text');
	foreach my $t (@$texts) {
		$text .= MT::Template::Node::nodeValue($t);
	}

	my $is_utf8 = utf8::is_utf8($text);
	if ($is_utf8) {
		$text = encode('utf8', $text);
	}
	$text =~ tr/ 	/01/;
	$text =~ s/([^\r\n]+)/pack('b*', $1)/ge;
	if ($is_utf8) {
		$text = decode('utf8', $text);
	}

	$ctx->build($text);
}

sub pre_save {
	my ($cb, $obj, $original) = @_;

	my @cols = ();
	if ($obj->datasource eq 'entry') {
		@cols = ('text', 'text_more');
	}
	elsif ($obj->datasource eq 'template') {
		@cols = ('text');
	}

	my $bleach = sub {
		my $text = shift;
		if ($text !~ m/^[\s\r\n]*$/) {
			my $is_utf8 = utf8::is_utf8($text);
			if ($is_utf8) {
				$text = encode('utf-8', $text);
			}
			$text =~ s/([^\r\n]+)/unpack('b*', $1)/ge;
			$text =~ tr/01/ 	/;
			if ($is_utf8) {
				$text = decode('utf-8', $text);
			}
		}
		$text;
	};

	foreach my $c (@cols) {
		my $text = $obj->$c;
		$text =~ s/(<mt:?bleach([^>]*)>)(.*?)(<\/mt:?bleach>)/"$1" . $bleach->($3) . "$4"/iseg;
		$obj->$c($text);
	}
}

sub source_edit_template {
	my ($cb, $app, $tmpl) = @_;

	my $replace = '(var editor = CodeMirror)';
	my $script = '<mt:Var name="bleach_java_script" />';
	$$tmpl =~ s#$replace#$script\n$1#i;
}

sub param_edit_template {
	my ($cb, $app, $param, $tmpl) = @_;

	if ($param->{'text'} =~ m/(<mt:?bleach([^>]*)>)(.*?)(<\/mt:?bleach>)/is) {
		$param->{'bleach_java_script'} = <<__EOS__;
parsers.push('../../plugins/Bleach/js/editor.js');
__EOS__
	}
}

1;
