<?php
# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

function bleach_binstr_to_integer($bin) {
	$int = 0;
	foreach (preg_split('//', $bin) as $k => $v) {
		$int += pow(2, $k-1) * $v;
	}

	return dechex($int);
}

function smarty_block_MTBleach($args, $content, &$ctx, &$repeat) {
	if ($content) {
		$chars = array();
		$content = str_replace(
			array(' ', "\t", "\n", "\r"), array(0, 1, '', ''), $content
		);
		$content = preg_replace(
			'/(\d{4})/e', 'bleach_binstr_to_integer(\'\1\')', $content
		);
		$content = pack('h*', $content);
	}
	return $content;
}

?>
