/*
 * Copyright (C) 2010-2011 Mtzky.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky;

import static org.mtzky.log.ThreadUtils.*;

import org.mtzky.log.ThreadUtils;

/**
 * <p>
 * Thrown if a utility class is constructed.
 * </p>
 * 
 * @author mtzky
 */
public class UtilConstractedAssertionError extends AssertionError {

	private static final long serialVersionUID = -7195646111122895661L;

	/**
	 * <p>
	 * {@link AssertionError} detail message: <code>{@value #MESSAGE}</code>
	 * </p>
	 */
	protected static final String MESSAGE = "Instances should NOT be constructed: ";

	/**
	 * <p>
	 * Constructs an {@link AssertionError} with the {@link #MESSAGE detail
	 * message} and {@link ThreadUtils#getCallingClassName() the calling class
	 * name}.
	 * </p>
	 */
	public UtilConstractedAssertionError() {
		super(MESSAGE + getCallingClassName());
	}

}
