/*
 * Copyright (C) 2010-2011 Mtzky.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.io;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * <p>
 * {@link PrintStream} with {@link ByteArrayOutputStream}.
 * </p>
 * <p lang="ja">
 * 文字列として扱うための {@link PrintStream} です。
 * </p>
 * 
 * @author mtzky
 */
public class SPrintStream extends PrintStream {

	public SPrintStream() {
		super(new ByteArrayOutputStream(), true);
	}

	public SPrintStream(final int size) {
		super(new ByteArrayOutputStream(size), true);
	}

	@Override
	public String toString() {
		return out.toString();
	}

}
