/*
 * Copyright (C) 2010-2011 Mtzky.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.io;

import static org.mtzky.io.IOUtils.*;
import static org.mtzky.log.GenericMarker.*;
import static org.mtzky.log.ThreadUtils.*;
import static org.slf4j.LoggerFactory.*;

import org.slf4j.Logger;

/**
 * <p>
 * {@link Object#finalize() Finalizer} guardian for {@link Closable}.
 * </p>
 * 
 * @see Closable
 * @author mtzky
 */
public class ClosingGuardian {

	private static final Logger LOG = getLogger(ClosingGuardian.class);

	private final Closable closable;
	private final StackTraceElement owner;

	public ClosingGuardian(final Closable closable) {
		if (closable == null) {
			throw new NullPointerException("closable");
		}
		this.closable = closable;
		this.owner = getCallingStackTraceElement();
	}

	@Override
	protected void finalize() {
		LOG.warn(CLOSE, "close {} at {}", closable, owner);
		closeQuietly(closable);
	}

}
