/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.io;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * <p>
 * {@link PrintWriter} with {@link StringWriter}.
 * </p>
 * <p lang="ja">
 * 文字列として扱うための {@link PrintWriter} です。
 * </p>
 * <address>
 * This class is a redistribution from '<a href="https://www.seasar.org/svn/s2container/!svn/bc/4486/trunk/seasar2/s2-framework/src/main/java/org/seasar/framework/util/SPrintWriter.java"
 * >SPrintWriter.java</a>' at revision 4486 in <a
 * href="http://s2container.seasar.org/">S2Container</a>. The
 * original source code copyright:<br>
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 * </address>
 * 
 * @author mtzky
 */
public class SPrintWriter extends PrintWriter {

	public SPrintWriter() {
		super(new StringWriter());
	}

	public SPrintWriter(final int size) {
		super(new StringWriter(size));
	}

	@Override
	public String toString() {
		return out.toString();
	}

}
