/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.log;

import static java.lang.Character.*;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import org.mtzky.UtilConstractedAssertionError;
import org.mtzky.io.SPrintWriter;

/**
 * <p>
 * Dump utilities.
 * </p>
 * 
 * @author mtzky
 */
public class DumpUtils {

	private DumpUtils() {
		throw new UtilConstractedAssertionError(DumpUtils.class);
	}

	/**
	 * <p>
	 * Returns {@code string} as hex numbers with the original text.
	 * </p>
	 * 
	 * @param string
	 *            to dump
	 * @return {@code string} as hex numbers with the original text
	 */
	public static String hex(final String string) {
		final PrintWriter w = new SPrintWriter();

		final byte[] bytes = string.getBytes();
		final int byteLen = bytes.length;
		final int digit = Integer.toString(byteLen, 16).length();
		final String lineFormat = "%0" + digit + "X:";
		for (int i = 0; i < byteLen; i++) {
			if (i % 16 == 0) {
				w.print(String.format(lineFormat, i));
			}
			w.print(String.format(" %02X", bytes[i]));
			if (i % 16 == 15) {
				w.print("  ");
				w.print(text(bytes, (i - 15), i + 1));
				w.println();
			}
		}
		final int remainder = byteLen % 16;
		if (remainder != 0) {
			for (int i = 0; i < (16 - remainder); i++) {
				w.print("   ");
			}
			w.print("  ");
			w.print(text(bytes, (byteLen - remainder), byteLen));
			w.println();
		}
		return w.toString();
	}

	private static String text(final byte[] bytes, final int f, final int t) {
		final List<Byte> buff = new ArrayList<Byte>(16);
		for (int i = f; i < t; i++) {
			final char c = (char) bytes[i];
			buff.add((byte) (isWhitespace(c) ? '.' : c));
		}
		final byte[] text = new byte[buff.size()];
		int i = 0;
		for (final Byte c : buff) {
			text[i++] = c;
		}
		return new String(text);
	}

}
