/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.io;

import org.mtzky.io.Closable;
import org.mtzky.io.IOUtils;
import org.mtzky.log.GenericMarker;
import org.mtzky.log.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ClosingGuardian {
    private static final Logger LOG = LoggerFactory.getLogger(ClosingGuardian.class);
    private final Closable closable;
    private final StackTraceElement owner;

    public ClosingGuardian(Closable closable) {
        if (closable == null) {
            throw new NullPointerException("closable");
        }
        this.closable = closable;
        this.owner = ThreadUtils.getCallingStackTraceElement();
    }

    protected void finalize() {
        LOG.warn((Marker)GenericMarker.CLOSE, "close {} at {}", (Object)this.closable, (Object)this.owner);
        IOUtils.closeQuietly(this.closable);
    }
}

