/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.log;

import java.util.Iterator;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public enum GenericMarker implements Marker
{
    ROOT(new Marker[0]),
    FAILED(ROOT),
    LIFECYCLE(ROOT),
    FAILED_LIFECYCLE(FAILED, LIFECYCLE),
    PROCESS(ROOT),
    FAILED_PROCESS(FAILED, PROCESS),
    PROFILE(ROOT),
    INITIALIZE(LIFECYCLE),
    FAILED_TO_INITIALIZE(FAILED_LIFECYCLE, INITIALIZE),
    CANCEL(LIFECYCLE),
    FAILED_TO_CANCEL(FAILED_LIFECYCLE, CANCEL),
    CLOSE(LIFECYCLE),
    FAILED_TO_CLOSE(FAILED_LIFECYCLE, CLOSE),
    DESTROY(LIFECYCLE),
    FAILED_TO_DESTROY(FAILED_LIFECYCLE, DESTROY),
    ADD(PROCESS),
    FAILED_TO_ADD(FAILED_PROCESS, ADD),
    READ(PROCESS),
    FAILED_TO_READ(FAILED_PROCESS, READ),
    CHANGE(PROCESS),
    FAILED_TO_CHANGE(FAILED_PROCESS, CHANGE),
    DELETE(PROCESS),
    FAILED_TO_DELETE(FAILED_PROCESS, DELETE),
    PARSE(READ),
    FAILED_TO_PARSE(FAILED_TO_READ, PARSE),
    SHOW(READ),
    FAILED_TO_SHOW(FAILED_TO_READ, SHOW),
    LIST(READ),
    FAILED_TO_LIST(FAILED_TO_READ, LIST);

    private final Marker marker;

    private GenericMarker(Marker ... parents) {
        StringBuilder name = new StringBuilder();
        name.append(GenericMarker.class.getPackage().getName());
        if (0 < parents.length) {
            name.append('.').append(this.name());
        }
        this.marker = MarkerFactory.getMarker((String)name.toString());
        for (Marker parent : parents) {
            parent.add(this.marker);
        }
    }

    public void add(Marker reference) {
        this.marker.add(reference);
    }

    public boolean contains(Marker other) {
        return this.marker.contains(other);
    }

    public boolean contains(String name) {
        return this.marker.contains(name);
    }

    public String getName() {
        return this.marker.getName();
    }

    @Deprecated
    public boolean hasChildren() {
        return this.marker.hasReferences();
    }

    public boolean hasReferences() {
        return this.marker.hasReferences();
    }

    public Iterator<Marker> iterator() {
        return this.marker.iterator();
    }

    public boolean remove(Marker reference) {
        return this.marker.remove(reference);
    }
}

