/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.mtzky.reflect.InvocationTargetRuntimeException;

public class PropDesc {
    private Method getter;
    private Method setter;
    private Field field;
    private final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private final String name;

    public PropDesc(String name) {
        this.name = name;
    }

    public <T> T get(Object obj) {
        try {
            return (T)(this.getter != null ? this.getter.invoke(obj, new Object[0]) : this.field.get(obj));
        }
        catch (Exception e) {
            String fmt = "FAILED to get a value from the property '%s'";
            throw new InvocationTargetRuntimeException(String.format("FAILED to get a value from the property '%s'", this.name), e);
        }
    }

    public void set(Object obj, Object value) {
        try {
            if (this.setter != null) {
                this.setter.invoke(obj, value);
            } else {
                this.field.set(obj, value);
            }
        }
        catch (Exception e) {
            String fmt = "FAILED to set [%s] to the property '%s'";
            Object[] args = new Object[]{value, this.name};
            throw new InvocationTargetRuntimeException(String.format("FAILED to set [%s] to the property '%s'", args), e);
        }
    }

    public Class<?> getType() {
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        return this.field.getType();
    }

    public String getName() {
        return this.name;
    }

    public boolean hasGetter() {
        return this.getter != null;
    }

    public boolean hasSetter() {
        return this.getter != null;
    }

    public boolean hasField() {
        return this.field != null;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[this.annotations.size()]);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotations.get(annotationClass);
    }

    public void addAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            this.addAnnotation(annotation);
        }
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.annotationType(), annotation);
    }
}

