/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.reflect;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import org.mtzky.reflect.PropDesc;

public class PropsDesc {
    private final PropDesc[] descs;

    public PropsDesc(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        HashMap<String, PropDesc> descs = new HashMap<String, PropDesc>();
        for (Class<?> c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : c.getMethods()) {
                PropertyDescriptor propDesc;
                String name;
                String msg;
                if (method.getAnnotation(annotationClass) == null) continue;
                String mName = method.getName();
                if (mName.startsWith("get") || mName.startsWith("set")) {
                    if (mName.length() < 4) {
                        msg = "Invalid method name: " + method;
                        throw new IllegalArgumentException(msg);
                    }
                    name = mName.substring(3, 4).toLowerCase(Locale.ENGLISH) + mName.substring(4);
                } else if (mName.startsWith("is")) {
                    if (mName.length() < 3) {
                        msg = "Invalid method name: " + method;
                        throw new IllegalArgumentException(msg);
                    }
                    name = mName.substring(2, 3).toLowerCase(Locale.ENGLISH) + mName.substring(3);
                } else {
                    msg = "NOT getter/setter method: " + method;
                    throw new IllegalArgumentException(msg);
                }
                if (descs.containsKey(name)) continue;
                try {
                    propDesc = new PropertyDescriptor(name, clazz);
                }
                catch (IntrospectionException e) {
                    String msg2 = "Requires to define the pair of getter and setter: ";
                    throw new IllegalArgumentException("Requires to define the pair of getter and setter: " + name, e);
                }
                PropDesc desc = new PropDesc(name);
                desc.setGetter(propDesc.getReadMethod());
                desc.setSetter(propDesc.getWriteMethod());
                desc.addAnnotations(method.getAnnotations());
                descs.put(name, desc);
            }
            for (AccessibleObject accessibleObject : c.getFields()) {
                String name;
                if (((Field)accessibleObject).getAnnotation(annotationClass) == null || descs.containsKey(name = ((Field)accessibleObject).getName())) continue;
                PropDesc desc = new PropDesc(name);
                desc.setField((Field)accessibleObject);
                desc.addAnnotations(accessibleObject.getAnnotations());
                descs.put(name, desc);
            }
        }
        this.descs = descs.values().toArray(new PropDesc[descs.size()]);
        descs.clear();
    }

    public PropDesc[] getDescriptors() {
        return this.descs;
    }

    public <T> T[] wrap(WrapCallback<T> callback, T ... type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        Class<?> t = type.getClass().getComponentType();
        int len = this.descs.length;
        Object[] a = (Object[])Array.newInstance(t, len);
        for (int i = 0; i < len; ++i) {
            a[i] = callback.create(this.descs[i]);
        }
        return a;
    }

    public PropDesc find(FindCallback callback) {
        for (PropDesc desc : this.descs) {
            if (!callback.match(desc)) continue;
            return desc;
        }
        return null;
    }

    public static interface FindCallback {
        public boolean match(PropDesc var1);
    }

    public static interface WrapCallback<T> {
        public T create(PropDesc var1);
    }
}

