/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.reflect;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.mtzky.UtilConstractedAssertionError;

public class IterableUtils {
    private IterableUtils() {
        throw new UtilConstractedAssertionError(IterableUtils.class);
    }

    public static <E> E[] each(E[] a, Each<E> cb) {
        for (E v : a) {
            cb.call(v);
        }
        return a;
    }

    public static <E, IT extends Iterable<E>> IT each(IT it, Each<E> cb) {
        for (E v : it) {
            cb.call(v);
        }
        return it;
    }

    public static <E> E[] each(E[] a, EachWithIndex<E> cb) {
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            cb.call(a[i], i);
        }
        return a;
    }

    public static <E, IT extends Iterable<E>> IT each(IT it, EachWithIndex<E> cb) {
        int i = 0;
        for (E v : it) {
            cb.call(v, i++);
        }
        return it;
    }

    public static <E> E each(E[] a, Find<E> cb) {
        for (E v : a) {
            if (!cb.call(v)) continue;
            return v;
        }
        return null;
    }

    public static <E> E each(Iterable<E> it, Find<E> cb) {
        for (E v : it) {
            if (!cb.call(v)) continue;
            return v;
        }
        return null;
    }

    public static <E> boolean each(E[] a, Contain<E> cb) {
        for (E v : a) {
            if (!cb.call(v)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean each(Iterable<E> it, Contain<E> cb) {
        for (E v : it) {
            if (!cb.call(v)) continue;
            return true;
        }
        return false;
    }

    public static <FROM, TO> TO[] each(FROM[] a, Wrap<FROM, TO> cb, TO ... type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        Class<?> t = type.getClass().getComponentType();
        int len = a.length;
        Object[] wrapped = (Object[])Array.newInstance(t, len);
        for (int i = 0; i < len; ++i) {
            wrapped[i] = cb.call(a[i]);
        }
        return wrapped;
    }

    public static <FROM, TO> TO[] each(Iterable<FROM> it, Wrap<FROM, TO> cb, TO ... type) throws InstantiationException, IllegalAccessException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        ArrayList<TO> wrapped = new ArrayList<TO>();
        for (FROM v : it) {
            wrapped.add(cb.call(v));
        }
        Class<?> t = type.getClass().getComponentType();
        return wrapped.toArray((Object[])Array.newInstance(t, wrapped.size()));
    }

    public static interface Wrap<FROM, TO> {
        public TO call(FROM var1);
    }

    public static interface Contain<E> {
        public boolean call(E var1);
    }

    public static interface Find<E> {
        public boolean call(E var1);
    }

    public static interface EachWithIndex<E> {
        public void call(E var1, int var2);
    }

    public static interface Each<E> {
        public void call(E var1);
    }
}

