/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/**
 * <p>
 * InvocationTargetException is a checked exception that wraps an exception
 * thrown by an invoked method or constructor.
 * </p>
 * 
 * @see Method
 * @see Constructor
 * @author mtzky
 * @since 0.1.1
 */
public class InvocationTargetRuntimeException extends RuntimeException {

	private static final long serialVersionUID = 3289231693125800298L;

	/**
	 * @param cause
	 */
	public InvocationTargetRuntimeException(final Throwable cause) {
		super(cause);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public InvocationTargetRuntimeException(final String message,
			final Throwable cause) {
		super(message, cause);
	}

}
