/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene;

import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

/**
 * @author mtzky
 * @see LuceneIndexSearcher#find(LuceneIndexSearcherRequest)
 */
public interface LuceneIndexSearcherRequest {

	/**
	 * <p>
	 * Default {@link Query}: {@link MatchAllDocsQuery}
	 * </p>
	 */
	Query DEFAULT_QUERY = new MatchAllDocsQuery();

	/**
	 * <p>
	 * Default limit: <code>{@value}</code> hits
	 * </p>
	 */
	int DEFAULT_LIMIT = 10;

	/**
	 * @return {@link Query}, or {@link MatchAllDocsQuery} if undefined.
	 * @see #DEFAULT_QUERY
	 */
	Query getQuery();

	/**
	 * @return {@link Filter}
	 */
	Filter getFilter();

	/**
	 * @return limit, or {@value #DEFAULT_LIMIT} if undefined.
	 * @see #DEFAULT_LIMIT
	 */
	int getLimit();

	/**
	 * @return offset, or 0 if undefined.
	 */
	int getOffset();

	/**
	 * @return {@link Sort}, or {@code null} if empty.
	 */
	Sort getSort();

}
