/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.filter;

import org.apache.lucene.analysis.TokenStream;

/**
 * <p>
 * Normalizes Hiragana to Katakana.
 * </p>
 * <p>
 * Adds 96 to U+3041 ... U+3096 in the Hiragana range.
 * </p>
 * 
 * @author mtzky
 */
public class HiraganaToKatakanaFilter extends CharToCharMappingTokenFilter {

	/**
	 * @param in
	 */
	public HiraganaToKatakanaFilter(final TokenStream in) {
		super(in);
	}

	@Override
	protected char convert(final char c) {
		return (0x3041 <= c && c <= 0x3096) ? (char) (c + 96) : c;
	}

}
