/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.filter;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

import org.apache.lucene.analysis.TokenStream;

/**
 * <p>
 * Kanji variants normalizing {@link Reader}.
 * </p>
 * <table lang="ja" border="1">
 * <caption>統合漢字属性を持つ互換漢字</caption><thead>
 * <tr>
 * <th colspan="2">-</th>
 * <th colspan="2">異体字</th>
 * </tr>
 * <tr>
 * <th>code</th>
 * <th>glyph</th>
 * <th>code</th>
 * <th>glyph</th>
 * </tr>
 * </thead><tbody>
 * <tr>
 * <td>U+FA0E</td>
 * <td>&#xfa0e;</td>
 * <td colspan="2">-</td>
 * </tr>
 * <tr>
 * <td>U+FA0F</td>
 * <td>&#xfa0f;</td>
 * <td colspan="2">-</td>
 * </tr>
 * <tr>
 * <td>U+FA11</td>
 * <td>&#xfa11;</td>
 * <td>U+5D0E</td>
 * <td>&#x5d0e;</td>
 * </tr>
 * <tr>
 * <td>U+FA13</td>
 * <td>&#xfa13;</td>
 * <td colspan="2">-</td>
 * </tr>
 * <tr>
 * <td>U+FA14</td>
 * <td>&#xfa14;</td>
 * <td>U+6B05, U+6989</td>
 * <td>&#x6b05;, &#x6989;</td>
 * </tr>
 * <tr>
 * <td>U+FA1F</td>
 * <td>&#xfa1f;</td>
 * <td>U+81C8</td>
 * <td>&#x81c8;</td>
 * </tr>
 * <tr>
 * <td>U+FA21</td>
 * <td>&#xfa21;</td>
 * <td colspan="2">-</td>
 * </tr>
 * <tr>
 * <td>U+FA23</td>
 * <td>&#xfa23;</td>
 * <td colspan="2">-</td>
 * </tr>
 * <tr>
 * <td>U+FA24</td>
 * <td>&#xfa24;</td>
 * <td colspan="2">-</td>
 * </tr>
 * <tr>
 * <td>U+FA27</td>
 * <td>&#xfa27;</td>
 * <td colspan="2">-</td>
 * </tr>
 * <tr>
 * <td>U+FA28</td>
 * <td>&#xfa28;</td>
 * <td colspan="2">-</td>
 * </tr>
 * <tr>
 * <td>U+FA29</td>
 * <td>&#xfa29;</td>
 * <td colspan="2">-</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author mtzky
 * @deprecated under implementation
 */
@Deprecated
public class KanjiVariantsFilter extends CharToCharMappingTokenFilter {

	private static final Map<Character, Character> MAP = new HashMap<Character, Character>();
	static {
		MAP.put('\uFA11', '崎');
		MAP.put('\uFA14', '欅');
		/* tentative: U+6989 to U+6B05 */
		MAP.put('\u6989', '欅');
		MAP.put('\uFA1F', '臈');
	}

	public KanjiVariantsFilter(final TokenStream in) {
		super(in);
	}

	@Override
	protected char convert(final char c) {
		final Character another = MAP.get(c);
		if (another == null) {
			return c;
		}
		return another;
	}

}
