/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.type;

import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;

/**
 * @author mtzky
 */
@LuceneFieldStrategyType(Boolean.class)
public class LuceneBooleanStrategy extends LuceneStringStrategy {

	private static final String FALSE = "0";
	private static final String TRUE = "1";

	/**
	 * @param config
	 */
	public LuceneBooleanStrategy(final LucenePropertyConfig config) {
		super(config);
	}

	@Override
	public Fieldable getField(final Object value) {
		final Fieldable f = super.getField(value);
		f.setOmitNorms(true);
		return f;
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T getValue(final Fieldable field) {
		return (T) Boolean.valueOf(TRUE.equals(field.stringValue()));
	}

	@Override
	protected String toString(final Object value) {
		return (value != null && (Boolean) value) ? TRUE : FALSE;
	}

}
