/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.type;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParsePosition;

import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;

/**
 * @author mtzky
 */
@LuceneFieldStrategyType(Byte.class)
public class LuceneByteStrategy extends LuceneIntegerStrategy {

	private final boolean original;
	private final String format;

	/**
	 * @param config
	 */
	public LuceneByteStrategy(final LucenePropertyConfig config) {
		super(config);
		this.format = config.getFormat();
		this.original = format.isEmpty();
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T getValue(final Fieldable field) {
		final String v = field.stringValue();
		if (original) {
			return (T) Byte.valueOf(v);
		}
		final DecimalFormat format = new DecimalFormat(this.format);
		format.setParseBigDecimal(true);
		final BigDecimal d = (BigDecimal) format.parse(v, new ParsePosition(0));
		return (T) Byte.valueOf((d != null) ? d.byteValue() : 0);
	}

	@Override
	protected int toInt(final Object value) {
		return (value != null) ? (Byte) value : 0;
	}

}
