/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.descriptor;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

/**
 * <p>
 * {@link Document} entity descriptor.
 * </p>
 * 
 * @param <E>
 *            {@code entity}
 * @author mtzky
 */
public interface LuceneDocumentDesc<E> {

	/**
	 * @return the identify field name
	 */
	String getIdName();

	/**
	 * @param entity
	 * @return the term to identify the document(s) to be deleted
	 * @see IndexWriter#updateDocument(Term, Document)
	 * @see IndexWriter#deleteDocuments(Term)
	 */
	Term getIdTermByEntity(E entity);

	/**
	 * @param value
	 * @return the term to identify the document(s) to be found
	 */
	Term getIdTermByValue(Object value);

	/**
	 * @return {@link Analyzer}
	 */
	Analyzer getAnalyzer();

	/**
	 * <p>
	 * Creates {@link Document} from {@code entity}.
	 * </p>
	 * 
	 * @param entity
	 * @return {@link Document}
	 */
	Document createDocument(E entity);

	/**
	 * <p>
	 * Creates {@code entity} from {@link Document}.
	 * </p>
	 * 
	 * @param document
	 * @return {@code entity}
	 */
	E createEntity(Document document);

}
