/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.descriptor;

import java.util.Map;

import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;

/**
 * @param <T>
 *            entity value type
 * @author mtzky
 */
public class MapPropertyDesc<T> extends AbstractPropertyDesc<Map<String, T>> {

	private final String name;

	public MapPropertyDesc(final LucenePropertyConfig config) {
		super(config);
		this.name = config.getName();
	}

	@Override
	public Fieldable getField(final Map<String, T> entity) {
		return getFieldByValue(entity.get(name));
	}

	@Override
	@SuppressWarnings("unchecked")
	public void setField(final Map<String, T> entity, final Fieldable field) {
		entity.put(name, (T) getValue(field));
	}

	@Override
	public Term getTerm(final Map<String, T> entity) {
		return getTermByValue(entity.get(name));
	}

}
