/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.filter;

import java.io.IOException;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

/**
 * <p>
 * Normalizes a character in the token text to another character.
 * </p>
 * 
 * @author mtzky
 */
public abstract class CharToCharMappingTokenFilter extends TokenFilter {

	private final CharTermAttribute termAttr;

	public CharToCharMappingTokenFilter(final TokenStream input) {
		super(input);
		this.termAttr = addAttribute(CharTermAttribute.class);
	}

	@Override
	public final boolean incrementToken() throws IOException {
		if (input.incrementToken()) {
			final char[] buffer = termAttr.buffer();
			final int length = termAttr.length();
			for (int i = 0; i < length; i++) {
				buffer[i] = convert(buffer[i]);
			}
			return true;
		}
		return false;
	}

	/**
	 * @param c
	 *            character to convert
	 * @return a converted character
	 */
	protected abstract char convert(char c);

}
