/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.query;

import static org.apache.lucene.util.NumericUtils.*;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.ToStringUtils;

/**
 * {@link Term} with {@link NumericUtils#doubleToPrefixCoded(double)}.
 * 
 * @author mtzky
 */
public class DoubleTermQuery extends TermQuery {

	private static final long serialVersionUID = -6547765424751833742L;

	private final double value;

	/**
	 * <p>
	 * Constructs a {@link TermQuery} with the given field and value.
	 * </p>
	 * 
	 * @param field
	 * @param value
	 */
	public DoubleTermQuery(final String field, final double value) {
		super(new Term(field, doubleToPrefixCoded(value)));
		this.value = value;
	}

	@Override
	public String toString(final String field) {
		final Term term = getTerm();
		final StringBuilder sb = new StringBuilder();
		if (!term.field().equals(field)) {
			sb.append(term.field()).append(':');
		}
		sb.append("<doubleToPrefixCoded ").append(value).append('>');
		sb.append(ToStringUtils.boost(getBoost()));
		return sb.toString();
	}

}
