/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.query;

import static org.apache.lucene.util.Version.*;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

/**
 * @author mtzky
 */
public class LuceneQueryParser extends QueryParser {

	private static final Query MATCH_NO_DOCS_QUERY = new MatchNoDocsQuery();

	public LuceneQueryParser(final String field, final Analyzer analyzer) {
		super(LUCENE_31, field, analyzer);
	}

	@Override
	protected Query getFieldQuery(final String field, final String queryText,
			final boolean quoted) throws ParseException {
		final Query query = super.getFieldQuery(field, queryText, quoted);
		return query != null ? query : MATCH_NO_DOCS_QUERY;
	}

	@Override
	protected Query getPrefixQuery(final String field, final String termStr)
			throws ParseException {
		final Query query = super.getPrefixQuery(field, termStr);
		return query != null ? query : MATCH_NO_DOCS_QUERY;
	}

}
