/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.type;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.Field.Index;
import org.apache.lucene.document.Field.Store;
import org.apache.lucene.index.Term;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;

/**
 * @author mtzky
 */
@LuceneFieldStrategyType(value = String.class)
public class LuceneStringStrategy implements LuceneFieldStrategy {

	private static final String EMPTY = "";

	private final String name;
	private final Store store;
	private final Index index;

	/**
	 * @param config
	 */
	public LuceneStringStrategy(final LucenePropertyConfig config) {
		this.name = config.getName();
		this.store = config.getStore();
		this.index = config.getIndex();
	}

	@Override
	public Fieldable getField(final Object value) {
		return new Field(name, toString(value), store, index);
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T getValue(final Fieldable field) {
		return (T) field.stringValue();
	}

	@Override
	public Term getTerm(final Object value) {
		return new Term(name, toString(value));
	}

	/**
	 * @param value
	 * @return value converted to {@link String}
	 */
	protected String toString(final Object value) {
		return (value != null) ? value.toString() : EMPTY;
	}

}
