/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.analyzer;

import static org.apache.lucene.util.Version.*;

import java.io.IOException;
import java.io.Reader;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.Version;
import org.mtzky.lucene.tokenizer.UnicodeBlockTokenizer;

/**
 * <p>
 * Tokenizes the entire stream as a unigram token of the Unicode code point.
 * </p>
 * 
 * @see UnicodeBlockTokenizer
 * @author mtzky
 */
public class UnicodeBlockAnalyzer extends Analyzer {

	public UnicodeBlockAnalyzer() {
		this(LUCENE_31);
	}

	/**
	 * @param matchVersion
	 *            {@link Version}
	 */
	public UnicodeBlockAnalyzer(final Version matchVersion) {
		super();
	}

	@Override
	public final TokenStream tokenStream(final String fieldName,
			final Reader reader) {
		return new UnicodeBlockTokenizer(reader);
	}

	@Override
	public final TokenStream reusableTokenStream(final String fieldName,
			final Reader reader) throws IOException {
		return tokenStream(fieldName, reader);
	}

}
