/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.query;

import java.io.IOException;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

/**
 * <p>
 * A query that not matches any documents.
 * </p>
 * 
 * @see org.apache.lucene.search.MatchAllDocsQuery
 * @author mtzky
 */
/* XXX 2011/05/03 mtzky @SuppressWarnings("deprecation") */
@SuppressWarnings("deprecation")
public class MatchNoDocsQuery extends Query {

	private static final long serialVersionUID = 1663886185814770816L;

	private static final String NAME = MatchNoDocsQuery.class.getSimpleName();

	@Override
	public Weight createWeight(final Searcher searcher) throws IOException {
		return new MatchNoDocsWeight();
	}

	@Override
	public String toString(final String field) {
		final StringBuilder sb = new StringBuilder();
		sb.append("*: ").append(NAME);
		sb.append(ToStringUtils.boost(getBoost()));
		return sb.toString();
	}

	private class MatchNoDocsWeight extends Weight {

		private static final long serialVersionUID = 5882359148073188883L;

		@Override
		public Explanation explain(final IndexReader reader, final int doc)
				throws IOException {
			return new ComplexExplanation(false, getValue(), NAME);
		}

		@Override
		public Query getQuery() {
			return MatchNoDocsQuery.this;
		}

		@Override
		public float getValue() {
			return 0;
		}

		@Override
		public void normalize(final float norm) {
		}

		@Override
		public Scorer scorer(final IndexReader reader,
				final boolean scoreDocsInOrder, final boolean topScorer)
				throws IOException {
			return null;
		}

		@Override
		public float sumOfSquaredWeights() throws IOException {
			return 0;
		}

		@Override
		public String toString() {
			return "weight(" + MatchNoDocsQuery.this + ")";
		}

	}

}
