/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.descriptor;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;

/**
 * @param <E>
 *            {@code entity}
 * @author mtzky
 */
public interface LucenePropertyDesc<E> extends LucenePropertyConfig {

	/**
	 * @param entity
	 * @return {@link NumericField} if the property type is numeric, or
	 *         {@link Field}
	 */
	Fieldable getField(E entity);

	/**
	 * @param value
	 * @return {@link NumericField} if the property type is numeric, or
	 *         {@link Field}
	 */
	Fieldable getFieldByValue(Object value);

	/**
	 * @param entity
	 * @param field
	 *            {@link Fieldable}
	 */
	void setField(E entity, Fieldable field);

	/**
	 * @param field
	 *            {@link Fieldable}
	 */
	Object getValue(Fieldable field);

	/**
	 * @param entity
	 * @return {@link Term} normalized by the property type
	 */
	Term getTerm(E entity);

	/**
	 * @param value
	 * @return {@link Term} normalized by the property type
	 */
	Term getTermByValue(Object value);

}
