<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD2ND_TRUST_PATH . '/class/AbstractListAction.class.php';

/**
 * Sd2nd_CostumeListAction
**/
class Sd2nd_CostumeListAction extends Sd2nd_AbstractUpdateListAction
{
    /**
     * &_getHandler
     * 
     * @param   void
     * 
     * @return  Sd2nd_CostumeHandler
    **/
    protected function &_getHandler()
    {
        $handler =& $this->mAsset->getObject('handler', 'costume');
        return $handler;
    }

    /**
     * &_getFilterForm
     * 
     * @param   void
     * 
     * @return  Sd2nd_CostumeFilterForm
    **/
    protected function &_getFilterForm()
    {
        // $filter =& new Sd2nd_CostumeFilterForm();
        $filter =& $this->mAsset->getObject('filter', 'costume',false);
        $filter->prepare($this->_getPageNavi(), $this->_getHandler());
        return $filter;
    }

    /**
     * _getBaseUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    protected function _getBaseUrl()
    {
        return './index.php?action=CostumeList';
    }

    /**
     * executeViewIndex
     * 
     * @param   XCube_RenderTarget  &$render
     * 
     * @return  void
    **/
    public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
    {
        $render->setTemplateName($this->mAsset->mDirname . '_costume_list.html');
        #cubson::lazy_load_array('costume', $this->mObjects);
        $render->setAttribute('objects', $this->mObjects);
        $render->setAttribute('pageNavi', $this->mFilter->mNavi);
        $render->setAttribute('updateHandler',$this->_mUpdateHandler);
    }
}

?>
