<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD2ND_TRUST_PATH . '/class/AbstractListAction.class.php';

/**
 * Sd2nd_LearnedSkillListAction
**/
class Sd2nd_LearnedSkillListAction extends Sd2nd_AbstractListAction
{
    /**
     * &_getHandler
     * 
     * @param   void
     * 
     * @return  Sd2nd_LearnedSkillHandler
    **/
    protected function &_getHandler()
    {
        $handler =& $this->mAsset->getObject('handler', 'char');
        return $handler;
    }

    /**
     * &_getFilterForm
     * 
     * @param   void
     * 
     * @return  Sd2nd_LearnedSkillFilterForm
    **/
    protected function &_getFilterForm()
    {
        // $filter =& new Sd2nd_LearnedSkillFilterForm();
        $filter =& $this->mAsset->getObject('filter', 'learnedSkill',false);
        $filter->prepare($this->_getPageNavi(), $this->_getHandler());
        return $filter;
    }

    /**
     * _getBaseUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    protected function _getBaseUrl()
    {
        return './index.php?action=LearnedSkillList';
    }

    /**
     * getDefaultView
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getDefaultView()
    {
        $this->mFilter =& $this->_getFilterForm();
        $this->mFilter->fetch();
        
        $handler =& $this->_getHandler();
        $this->mObjects =& $handler->getLearnedSkill($this->mFilter->getCriteria());
        
        return SD2ND_FRAME_VIEW_INDEX;
    }

    /**
     * executeViewIndex
     * 
     * @param   XCube_RenderTarget  &$render
     * 
     * @return  void
    **/
    public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
    {
        $render->setTemplateName($this->mAsset->mDirname . '_learned_skill_list.html');
        #cubson::lazy_load_array('learned_skill', $this->mObjects);
        $render->setAttribute('objects', $this->mObjects);
        $render->setAttribute('pageNavi', $this->mFilter->mNavi);
    }
}

?>
