<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_CharObject
**/
class Sd2nd_CharObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('full_name', XOBJ_DTYPE_STRING, '', false, 40);
        $this->initVar('nick_name', XOBJ_DTYPE_STRING, '', false, 16);
        $this->initVar('battle_name', XOBJ_DTYPE_STRING, '', false, 16);
        $this->initVar('sex', XOBJ_DTYPE_INT, '', false);
        $this->initVar('age', XOBJ_DTYPE_INT, '', false);
        $this->initVar('height', XOBJ_DTYPE_INT, '', false);
        $this->initVar('weight', XOBJ_DTYPE_INT, '', false);
        $this->initVar('profile', XOBJ_DTYPE_TEXT, '', false);
        $this->initVar('race', XOBJ_DTYPE_INT, '', false);
        $this->initVar('element_base', XOBJ_DTYPE_INT, '', false);
        $this->initVar('element_ext', XOBJ_DTYPE_INT, '', false);
        $this->initVar('active_costume', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_DummyCharObject
**/
class Sd2nd_DummyCharObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   string[]    $columns
     * 
     * @return  void
    **/
    public function __construct(/*** string[] ***/ $columns = array())
    {
        $this->initVar('eno',XOBJ_DTYPE_INT);
        $this->initVar('name',XOBJ_DTYPE_STRING);
        foreach($columns as $col)
        {
            $this->initVar($col,XOBJ_DTYPE_STRING);
        }
    }
}

/**
 * Sd2nd_CharHandler
**/
class Sd2nd_CharHandler extends XoopsObjectGenericHandler
{
    public /*** string ***/ $mTable = '{dirname}_char';
    public /*** string ***/ $mPrimary = 'eno';
    public /*** string ***/ $mClass = 'Sd2nd_CharObject';
    protected /*** string ***/ $_mAbilityTable = '{dirname}_ability';
    protected /*** string ***/ $_mSkillTable = '{dirname}_skill';
    protected /*** string ***/ $_mActiveAbilityTable = '{dirname}_active_ability';
    protected /*** string ***/ $_mLearnedAbilityTable = '{dirname}_learned_ability';
    protected /*** string ***/ $_mLearnedSkillTable = '{dirname}_learned_skill';
    
    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $replace = array('{dirname}' => $dirname);
        $this->mTable = strtr($this->mTable,$replace);
        $this->_mAbilityTable = $db->prefix(strtr($this->_mAbilityTable,$replace));
        $this->_mSkillTable = $db->prefix(strtr($this->_mSkillTable,$replace));
        $this->_mActiveAbilityTable = $db->prefix(strtr($this->_mActiveAbilityTable,$replace));
        $this->_mLearnedAbilityTable = $db->prefix(strtr($this->_mLearnedAbilityTable,$replace));
        $this->_mLearnedSkillTable = $db->prefix(strtr($this->_mLearnedSkillTable,$replace));
        parent::XoopsObjectGenericHandler($db);
    }
    
    /**
     * _escape
     * 
     * @param   string  $str
     * 
     * @return  string
    **/
    protected function _escape(/*** string ***/ $str)
    {
        return mysql_real_escape_string($str,$this->db->conn);
    }
    
    /**
     * &getActiveAbility
     * 
     * @param   CriteriaElement $cri
     * 
     * @return  Sd2nd_DummyCharObject[]
    **/
    public function &getActiveAbility(CriteriaElement $cri)
    {
        $ret = array();
        $sqlBase = 'SELECT `c`.`eno` AS eno,`c`.`full_name` AS name,{0} FROM `{1}` AS c {2} WHERE {3} GROUP BY `c`.`eno` ORDER BY `c`.`eno` ASC';
        $columns = array();
        $tables = array();
        $where = array();
        for($i = 1;$i <= 5;$i++)
        {
            $columns[] = XCube_Utils::formatString('`a{0}`.`ability_name` AS slot{0}',$i);
            $tables[] = XCube_Utils::formatString(
                'LEFT JOIN `{0}` AS s{1} ON `c`.`eno` = `s{1}`.`eno` AND `s{1}`.`slot` = {1} '
              . 'LEFT JOIN `{2}` AS a{1} ON `a{1}`.`ability_id` = `s{1}`.`ability_id`',
                $this->_mActiveAbilityTable,$i,$this->_mAbilityTable
            );
        }
        for($i = 0;$i < $cri->getCountChildElements();$i++)
        {
            $c = $cri->getChildElement($i);
            $tables[] = XCube_Utils::formatString(
                'LEFT JOIN `{0}` AS w{1} ON `c`.`eno` = `w{1}`.`eno` '
              . 'LEFT JOIN `{2}` AS n{1} ON `n{1}`.`ability_id` = `w{1}`.`ability_id`',
                $this->_mActiveAbilityTable,$i,$this->_mAbilityTable
            );
            $where[] = XCube_Utils::formatString(
                "`n{0}`.`ability_name` LIKE '{1}%'",
                $i,$this->_escape($c->getValue())
            );
        }
        $sql = XCube_Utils::formatString($sqlBase,implode(',',$columns),$this->mTable,implode(' ',$tables),implode(' AND ',$where));
        if($res = $this->db->query($sql,$cri->getLimit(),$cri->getStart()))
        {
            while($row = $this->db->fetchArray($res))
            {
                $obj = new Sd2nd_DummyCharObject(array('slot1','slot2','slot3','slot4','slot5'));
                $obj->setVars($row);
                $ret[] =& $obj;
                unset($obj);
            }
        }
        return $ret;
    }
    
    /**
     * getActiveAbilityCount
     * 
     * @param   CriteriaElement $cri
     * 
     * @return  int
    **/
    public function getActiveAbilityCount(CriteriaElement $cri)
    {
        $ret = null;
        $c = $cri->getChildElement(0);
        $sql = XCube_Utils::formatString(
            'SELECT COUNT(DISTINCT `w0`.`eno`) AS c FROM `{0}` AS w0 '
          . 'LEFT JOIN `{1}` AS n0 ON `n0`.`ability_id` = `w0`.`ability_id` ',
            $this->_mActiveAbilityTable,$this->_mAbilityTable
        );
        $where = "`n0`.`ability_name` LIKE '" . $this->_escape($c->getValue()) . "%' ";
        for($i = 1;$i < $cri->getCountChildElements();$i++)
        {
            $c = $cri->getChildElement($i);
            $sql .= XCube_Utils::formatString(
                'LEFT JOIN `{0}` AS w{1} ON `w0`.`eno` = `w{1}`.`eno` '
              . 'LEFT JOIN `{2}` AS n{1} ON `n{1}`.`ability_id` = `w{1}`.`ability_id` ',
                $this->_mActiveAbilityTable,$i,$this->_mAbilityTable
            );
            $where .= XCube_Utils::formatString(
                "AND `n{0}`.`ability_name` LIKE '{1}%' ",
                $i,$this->_escape($c->getValue())
            );
        }
        if($res = $this->db->query($sql . ' WHERE ' . $where))
        {
            $row = $this->db->fetchArray($res);
            $ret = $row['c'];
        }
        return $ret;
    }
    
    /**
     * &getLearnedAbility
     * 
     * @param   CriteriaElement $cri
     * 
     * @return  Sd2nd_DummyCharObject[]
    **/
    public function &getLearnedAbility(CriteriaElement $cri)
    {
        $ret = array();
        $sqlBase = 'SELECT `c`.`eno` AS eno,`c`.`full_name` AS name FROM `{0}` AS c {1} WHERE {2} GROUP BY `c`.`eno` ORDER BY `c`.`eno` ASC';
        $tables = array();
        $where = array();
        for($i = 0;$i < $cri->getCountChildElements();$i++)
        {
            $c = $cri->getChildElement($i);
            $tables[] = XCube_Utils::formatString(
                'LEFT JOIN `{0}` AS w{1} ON `c`.`eno` = `w{1}`.`eno` '
              . 'LEFT JOIN `{2}` AS n{1} ON `n{1}`.`ability_id` = `w{1}`.`ability_id`',
                $this->_mLearnedAbilityTable,$i,$this->_mAbilityTable
            );
            $where[] = XCube_Utils::formatString(
                "`n{0}`.`ability_name` LIKE '{1}%'",
                $i,$this->_escape($c->getValue())
            );
        }
        $sql = XCube_Utils::formatString($sqlBase,$this->mTable,implode(' ',$tables),implode(' AND ',$where));
        if($res = $this->db->query($sql,$cri->getLimit(),$cri->getStart()))
        {
            while($row = $this->db->fetchArray($res))
            {
                $obj = new Sd2nd_DummyCharObject();
                $obj->setVars($row);
                $ret[] =& $obj;
                unset($obj);
            }
        }
        return $ret;
    }
    
    /**
     * getLearnedAbilityCount
     * 
     * @param   CriteriaElement $cri
     * 
     * @return  int
    **/
    public function getLearnedAbilityCount(CriteriaElement $cri)
    {
        $ret = null;
        $c = $cri->getChildElement(0);
        $sql = XCube_Utils::formatString(
            'SELECT COUNT(DISTINCT `w0`.`eno`) AS c FROM `{0}` AS w0 '
          . 'LEFT JOIN `{1}` AS n0 ON `n0`.`ability_id` = `w0`.`ability_id` ',
            $this->_mLearnedAbilityTable,$this->_mAbilityTable
        );
        $where = "`n0`.`ability_name` LIKE '" . $this->_escape($c->getValue()) . "%' ";
        for($i = 1;$i < $cri->getCountChildElements();$i++)
        {
            $c = $cri->getChildElement($i);
            $sql .= XCube_Utils::formatString(
                'LEFT JOIN `{0}` AS w{1} ON `w0`.`eno` = `w{1}`.`eno` '
              . 'LEFT JOIN `{2}` AS n{1} ON `n{1}`.`ability_id` = `w{1}`.`ability_id` ',
                $this->_mLearnedAbilityTable,$i,$this->_mAbilityTable
            );
            $where .= XCube_Utils::formatString(
                "AND `n{0}`.`ability_name` LIKE '{1}%' ",
                $i,$this->_escape($c->getValue())
            );
        }
        if($res = $this->db->query($sql . ' WHERE ' . $where))
        {
            $row = $this->db->fetchArray($res);
            $ret = $row['c'];
        }
        return $ret;
    }
    
    /**
     * &getLearnedSkill
     * 
     * @param   CriteriaElement $cri
     * 
     * @return  Sd2nd_DummyCharObject[]
    **/
    public function &getLearnedSkill(CriteriaElement $cri)
    {
        $ret = array();
        $sqlBase = 'SELECT `c`.`eno` AS eno,`c`.`full_name` AS name FROM `{0}` AS c {1} WHERE {2} GROUP BY `c`.`eno` ORDER BY `c`.`eno` ASC';
        $tables = array();
        $where = array();
        for($i = 0;$i < $cri->getCountChildElements();$i++)
        {
            $c = $cri->getChildElement($i);
            $tables[] = XCube_Utils::formatString(
                'LEFT JOIN `{0}` AS w{1} ON `c`.`eno` = `w{1}`.`eno` '
              . 'LEFT JOIN `{2}` AS n{1} ON `n{1}`.`skill_id` = `w{1}`.`skill_id`',
                $this->_mLearnedSkillTable,$i,$this->_mSkillTable
            );
            $where[] = XCube_Utils::formatString(
                "`n{0}`.`skill_name` LIKE '{1}%'",
                $i,$this->_escape($c->getValue())
            );
        }
        $sql = XCube_Utils::formatString($sqlBase,$this->mTable,implode(' ',$tables),implode(' AND ',$where));
        if($res = $this->db->query($sql,$cri->getLimit(),$cri->getStart()))
        {
            while($row = $this->db->fetchArray($res))
            {
                $obj = new Sd2nd_DummyCharObject();
                $obj->setVars($row);
                $ret[] =& $obj;
                unset($obj);
            }
        }
        return $ret;
    }
    
    /**
     * getLearnedSkillCount
     * 
     * @param   CriteriaElement $cri
     * 
     * @return  int
    **/
    public function getLearnedSkillCount(CriteriaElement $cri)
    {
        $ret = null;
        $c = $cri->getChildElement(0);
        $sql = XCube_Utils::formatString(
            'SELECT COUNT(DISTINCT `w0`.`eno`) AS c FROM `{0}` AS w0 '
          . 'LEFT JOIN `{1}` AS n0 ON `n0`.`skill_id` = `w0`.`skill_id` ',
            $this->_mLearnedSkillTable,$this->_mSkillTable
        );
        $where = "`n0`.`skill_name` LIKE '" . $this->_escape($c->getValue()) . "%' ";
        for($i = 1;$i < $cri->getCountChildElements();$i++)
        {
            $c = $cri->getChildElement($i);
            $sql .= XCube_Utils::formatString(
                'LEFT JOIN `{0}` AS w{1} ON `w0`.`eno` = `w{1}`.`eno` '
              . 'LEFT JOIN `{2}` AS n{1} ON `n{1}`.`skill_id` = `w{1}`.`skill_id` ',
                $this->_mLearnedSkillTable,$i,$this->_mSkillTable
            );
            $where .= XCube_Utils::formatString(
                "AND `n{0}`.`ability_name` LIKE '{1}%' ",
                $i,$this->_escape($c->getValue())
            );
        }
        if($res = $this->db->query($sql . ' WHERE ' . $where))
        {
            $row = $this->db->fetchArray($res);
            $ret = $row['c'];
        }
        return $ret;
    }
}

?>
