<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_ImageObject
**/
class Sd2nd_ImageObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('image_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('image_url', XOBJ_DTYPE_STRING, '', false, 255);
        $this->initVar('image_height', XOBJ_DTYPE_INT, '', false);
        $this->initVar('image_width', XOBJ_DTYPE_INT, '', false);
        $this->initVar('image_link', XOBJ_DTYPE_STRING, '', false, 255);
        $this->initVar('update_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_ImageHandler
**/
class Sd2nd_ImageHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_image';

    /**
     * @brief   string
    **/
    public $mPrimary = 'image_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_ImageObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }

    /**
     * getByUnique
     * 
     * @paarm   int $eno
     * 
     * @return  Sd2nd_ImageObject
    **/
    public function getByUnique(/*** int ***/ $eno)
    {
        $cri = new Criteria('eno',$eno);
        $cri->setSort('update_time','desc');
        $ret =& $this->getObjects($cri);
        
        if(!is_array($ret) || count($ret) != 1)
        {
            $ret = null;
            return $ret;
        }
        
        return $ret[0];
    }
}

?>
