<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_RaceObject
**/
class Sd2nd_RaceObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('race_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('race_name', XOBJ_DTYPE_STRING, '', false, 50);
    }
}

/**
 * Sd2nd_RaceHandler
**/
class Sd2nd_RaceHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_race';

    /**
     * @brief   string
    **/
    public $mPrimary = 'race_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_RaceObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
