<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_SkillObject
**/
class Sd2nd_SkillObject extends XoopsSimpleObject
{
    /**
     * @brief   Enum[]
    **/
    protected $_mElements = array();
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('skill_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('skill_name', XOBJ_DTYPE_STRING, '', false, 50);
        $this->initVar('description', XOBJ_DTYPE_STRING, '', true, 255);
        $this->initVar('range', XOBJ_DTYPE_INT, '', false);
        $this->initVar('target', XOBJ_DTYPE_INT, '', false);
        $this->initVar('kind', XOBJ_DTYPE_INT, '', false);
        $this->initVar('tp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('regist_time', XOBJ_DTYPE_INT, '', false);
    }
    
    /**
     * getShow
     * 
     * @param   string  $key
     * 
     * @return  string
    **/
    public function getShow(/*** string ***/ $key)
    {
        $ret = null;
        if($key == 'range')
        {
            $value = $this->get($key) * 0.1;
            $ret = ($value == 0 ? _MD_SD2ND_LANG_ELEMENT_EMPTY : sprintf('%1.1f',$value));
        }
        else
        {
            $ret = parent::getShow($key);
        }
        
        return $ret;
    }
    
    /**
     * addElement
     * 
     * @param   Enum    $element
     * 
     * @return  void
    **/
    public function addElement(/*** Enum ***/ $element)
    {
        $this->_mElements[] = $element;
    }
    
    /**
     * getElements
     * 
     * @param   void
     * 
     * @return  Enum[]
    **/
    public function getElements()
    {
        return $this->_mElements;
    }
}

/**
 * Sd2nd_SkillHandler
**/
class Sd2nd_SkillHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_skill';

    /**
     * @brief   string
    **/
    public $mPrimary = 'skill_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_SkillObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
