<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_StatusObject
**/
class Sd2nd_StatusObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('lv', XOBJ_DTYPE_INT, '', false);
        $this->initVar('life', XOBJ_DTYPE_INT, '', false);
        $this->initVar('soul', XOBJ_DTYPE_INT, '', false);
        $this->initVar('pow', XOBJ_DTYPE_INT, '', false);
        $this->initVar('str', XOBJ_DTYPE_INT, '', false);
        $this->initVar('dex', XOBJ_DTYPE_INT, '', false);
        $this->initVar('speed', XOBJ_DTYPE_INT, '', false);
        $this->initVar('mag', XOBJ_DTYPE_INT, '', false);
        $this->initVar('reg', XOBJ_DTYPE_INT, '', false);
        $this->initVar('con', XOBJ_DTYPE_INT, '', false);
        $this->initVar('exp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('money', XOBJ_DTYPE_INT, '', false);
        $this->initVar('sp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('base_hp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('base_at', XOBJ_DTYPE_INT, '', false);
        $this->initVar('base_df', XOBJ_DTYPE_INT, '', false);
        $this->initVar('base_mat', XOBJ_DTYPE_INT, '', false);
        $this->initVar('base_mdf', XOBJ_DTYPE_INT, '', false);
        $this->initVar('base_act', XOBJ_DTYPE_INT, '', false);
        $this->initVar('base_move', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_hp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_at', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_df', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_mat', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_mdf', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_act', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_move', XOBJ_DTYPE_INT, '', false);
        $this->initVar('equip_hp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('equip_at', XOBJ_DTYPE_INT, '', false);
        $this->initVar('equip_df', XOBJ_DTYPE_INT, '', false);
        $this->initVar('equip_mat', XOBJ_DTYPE_INT, '', false);
        $this->initVar('equip_mdf', XOBJ_DTYPE_INT, '', false);
        $this->initVar('equip_act', XOBJ_DTYPE_INT, '', false);
        $this->initVar('equip_move', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_StatusHandler
**/
class Sd2nd_StatusHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_status';

    /**
     * @brief   string
    **/
    public $mPrimary = 'eno';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_StatusObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
