<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

require_once SD2ND_TRUST_PATH . '/class/updater/AbstractProcess.class.php';

/**
 * @class   Sd2nd_UpdateUtils
**/
class Sd2nd_UpdateUtils
{
    /**
     * &getHandler
     * 
     * @param   Enum    $name
     * 
     * @return  XoopsObjectGenericHandler   $handler
     * @throw   Sd2nd_Exception
    **/
    public static function &getHandler(/*** Enum ***/ $name)
    {
        static $asset = null;
        
        if(!$asset instanceof Sd2nd_AssetManager)
        {
            $asset =& Sd2nd_AssetManager::getInstance(SD2ND_PUBLIC_NAME);
        }
        
        $ret =& $asset->getObject('handler',$name);
        if(!$ret instanceof XoopsObjectGenericHandler)
        {
            throw new Sd2nd_Exception('Handler "' . $name . '" is not found.');
        }
        
        return $ret;
    }
    
    /**
     * displayError
     * 
     * @param   Sd2nd_Exception    $e
     * 
     * @return  void
    **/
    public static function displayError(Sd2nd_Exception $e)
    {
        // htrace($e->__toString());
        // echo mb_convert_encoding($e->__toString(),SD2ND_ECHO_ENCODING,mb_internal_encoding());
        file_put_contents(SD2ND_TRUST_PATH . '/class/updater/backup/error.txt',$e->__toString());
    }
    
    #region for sub process methods
    /**
     * executeFilter
     * 
     * @param   string  $kind
     * 
     * @return  void
    **/
    public static function executeFilter(/*** string ***/ $kind)
    {
        $process = new XCube_Delegate();
        
        foreach(glob(SD2ND_TRUST_PATH . '/class/updater/' . $kind . '/*.class.php') as $file)
        {
            require_once $file;
            if(class_exists($class = Sd2nd_UpdateUtils::makeClassNameFromPath($kind,$file)))
            {
                $filter = new $class();
                if($filter instanceof Sd2nd_AbstractFilter)
                {
                    $filter->prepare(SD2ND_UPDATE_TIME);
                    $process->add(array($filter,'execute'),$filter->getPriority());
                }
                unset($filter);
            }
        }
        
        try
        {
            $process->call();
        }
        catch(Sd2nd_Exception $e)
        {
            Sd2nd_UpdateUtils::displayError($e);
            if($e->isFatal())
            {
                die();
            }
        }
    }
    
    /**
     * &getProcess
     * 
     * @param   string  $kind
     * @param   string  $name
     * 
     * @return  Sd2nd_AbstractProcess
    **/
    public static function &getProcess(/*** string ***/ $kind,/*** string ***/ $name)
    {
        static $processes = array();
        $ret = null;
        
        if(!isset($processes[$kind]))
        {
            $processes[$kind] = array();
            foreach(glob(SD2ND_TRUST_PATH . '/class/updater/' . $kind . '/*.class.php') as $file)
            {
                require_once $file;
                $class = Sd2nd_UpdateUtils::makeClassNameFromPath($kind,$file);
                if(class_exists($class))
                {
                    $instance = new $class();
                    if($instance instanceof Sd2nd_AbstractProcess)
                    {
                        $processes[$kind][$class] =& $instance;
                        $processes[$kind][$class]->prepare(SD2ND_UPDATE_TIME);
                    }
                    unset($instance);
                }
            }
        }
        
        if(isset($processes[$kind][$name = Sd2nd_UpdateUtils::makeClassName($kind,$name)]))
        {
            $ret =& $processes[$kind][$name];
        }
        
        return $ret;
    }
    
    /**
     * makeClassName
     * 
     * @param   string  $kind
     * @param   string  $name
     * 
     * @return  string
    **/
    public static function makeClassName(/*** string ***/ $kind,/*** string ***/ $name)
    {
        return 'Sd2nd_' . ucfirst($name) . ucfirst(basename($kind));
    }
    
    /**
     * makeClassNameFromPath
     * 
     * @param   string  $kind
     * @param   string  $path
     * 
     * @return  string
    **/
    public static function makeClassNameFromPath(/*** string ***/ $kind,/*** string ***/ $path)
    {
        return Sd2nd_UpdateUtils::makeClassName($kind,substr(basename($path),0,-10));
    }
    #endregion
    
    #region for convert methods
    /**
     * convertString
     * 
     * @param   string  $str
     * 
     * @return  string
    **/
    public static function convertString(/*** string ***/ $str)
    {
        return mb_convert_kana($str,'as',mb_internal_encoding());
    }
    
    /**
     * convertTableName
     * 
     * @param   Enum  $type
     * 
     * @return  string
    **/
    public static function convertTableName(/*** Enum ***/ $type)
    {
        $handler =& Sd2nd_UpdateUtils::getHandler($type);
        return $handler->mTable;
    }
    #endregion
    
    #region for parse methods
    /**
     * parseByRegex
     * 
     * @param   string  $line
     * @param   string  $pattern
     * 
     * @return  string[]
     * @throw   Sd2nd_Exception
    **/
    public static function parseByRegex(/*** string ***/ $line,/*** string ***/ $pattern)
    {
        $ret = array();
        if(!preg_match($pattern,$line,$ret))
        {
            throw new Sd2nd_Exception(array('line' => $line,'pattern' => $pattern));
        }
        
        return $ret;
    }
    
    /**
     * parseByExplode
     * 
     * @param   string      $line
     * @param   int         $count
     * @param   int         $offset
     * @param   int         $end
     * @param   string[]    $column
     * @param   string      $spliter
     * 
     * @return  string[]
     * @throw   Sd2nd_Exception
    **/
    public static function parseByExplode(/*** string ***/ $line,/*** int ***/ $count,/*** int ***/ $offset,/*** int ***/ $end = null,/*** string[] ***/ $column = null,/*** string ***/ $spliter = ',')
    {
        $ret = $end != null ? explode($spliter,substr($line,$offset,$end)) : explode($spliter,substr($line,$offset));
        if(count($ret) != $count)
        {
            throw new Sd2nd_Exception(array('line' => $line,'count' => $count,'offset' => $offset,'end' => $end,'column' => $column,'spliter' => $spliter,'result' => $ret));
        }
        
        if(is_array($column) && count($column) && $count)
        {
            $ret = array_combine($column,$ret);
        }
        
        return $ret;
    }
    #endregion
    
    #region for query methods
    /**
     * &createObject
     * 
     * @param   Enum    $type
     * 
     * @return  XoopsSimpleObject
    **/
    public static function &createObject(/*** Enum ***/ $type)
    {
        $handler =& Sd2nd_UpdateUtils::getHandler($type);
        return $handler->create(true);
    }
    
    /**
     * insertObject
     * 
     * @param   Enum                $type
     * @param   XoopsSimpleObject   &$obj
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public static function insertObject(/*** Enum ***/ $type,XoopsSimpleObject &$obj)
    {
        $handler =& Sd2nd_UpdateUtils::getHandler($type);
        if(!$handler->insert($obj,true))
        {
            throw new Sd2nd_QueryException(array('type' => $type,'object' => $obj));
        }
    }
    
    /**
     * deleteObject
     * 
     * @param   Enum                $type
     * @param   XoopsSimpleObject   $obj
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public static function deleteObject(/*** Enum ***/ $type,XoopsSimpleObject $obj)
    {
        $handler =& Sd2nd_UpdateUtils::getHandler($type);
        if(!$handler->delete($obj,true))
        {
            throw new Sd2nd_QueryException(array('type' => $type,'object' => $obj));
        }
    }
    
    /**
     * deleteMultiObjects
     * 
     * @param   Enum            $type
     * @param   CriteriaElement $cri
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public static function deleteMultiObjects(/*** Enum ***/ $type,CriteriaElement $cri)
    {
        $handler =& Sd2nd_UpdateUtils::getHandler($type);
        if(!$handler->deleteAll($cri,true))
        {
            throw new Sd2nd_QueryException(array('type' => $type,'criteria' => $cri));
        }
    }
    #endregion
}



/**
 * @class   Sd2nd_Exception
**/
class Sd2nd_Exception extends Exception
{
    /**
     * __construct
     * 
     * @param   string/mixed{}  $message
     * 
     * @return  void
    **/
    public function __construct(/*** string/mixed{} ***/ $message = null)
    {
        if(is_array($message))
        {
            $message = print_r($message,true);
        }
        
        parent::__construct($message);
    }
    
    /**
     * isFatal
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public function isFatal()
    {
        return true;
    }
    
    /**
     * __toString
     * 
     * @param   void
     * 
     * @return  string
    **/
    public function __toString()
    {
        return print_r($this,true);
    }
}

/**
 * @class   Sd2nd_QueryException
**/
class Sd2nd_QueryException extends Sd2nd_Exception
{
    /**
     * @brief   string{}
    **/
    protected $_mQuery = null;
    
    /**
     * __construct
     * 
     * @param   string/mixed{}  $message
     * 
     * @return  void
    **/
    public function __construct(/*** string/mixed{} ***/ $message)
    {
        parent::__construct($message);
        
        $root =& XCube_Root::getSingleton();
        $this->_mQuery = end($root->mController->mLogger->queries);
    }
}


?>
