<?php
/**
 * @file
 * @package Sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_BackupDispose
**/
class Sd2nd_BackupDispose extends Sd2nd_AbstractFilter
{
    const MAX_INSERT_ROWS = 500;
    const EXPORT_PATH = '/class/updater/backup';
    protected /*** string ***/ $_mFileName = 'sd2nd_%06d.sql';
    protected /*** Enum ***/ $_mTableName = array();
    protected /*** resource ***/ $_mHandler = null;
    
    /**
     * prepare
     * 
     * @param   int $updateTime
     * 
     * @return  void
    **/
    public function prepare(/*** int ***/ $updateTime)
    {
        parent::prepare($updateTime);
        
        $this->_mFileName = SD2ND_TRUST_PATH . self::EXPORT_PATH . '/' . sprintf($this->_mFileName,$updateTime);
    }
    
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_FINAL;
    }
    
    /**
     * _export
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    protected function _export()
    {
        $this->_mTableName = array_map(array('Sd2nd_UpdateUtils','convertTableName'),$this->_mTableName);
        $this->_mHandler = fopen($this->_mFileName,'wb');
        $this->_exportHeader();
        $this->_exportMain();
        $this->_exportFooter();
        fclose($this->_mHandler);
    }
    
    /**
     * _save
     * 
     * @param   string  $str
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    protected function _save(/*** string ***/ $str)
    {
        if(!is_resource($this->_mHandler))
        {
            throw new Sd2nd_Exception('Backup file "' . $this->_mFileName . '" cannot opened.');
        }
        
        fwrite($this->_mHandler,$str);
    }
    
    /**
     * _exportHeader
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    protected function _exportHeader()
    {
        $clear = array();
        $disable = array();
        $sql = sprintf("-- %s\n\nSET NAMES %s;\n\n-- reflesh tables\n",basename($this->_mFileName),SD2ND_DATABASE_ENCODING);
        
        foreach($this->_mTableName as $name)
        {
            $clear[] = 'TRUNCATE TABLE `' . $name . '`;';
            $disable[] = 'ALTER TABLE `' . $name . '` DISABLE KEYS;';
        }
        
        $this->_save($sql . implode("\n",$clear) . "\n-- disable keys\n" . implode("\n",$disable) . "\n");
    }
    
    /**
     * _exportMain
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    protected function _exportMain()
    {
        $root =& XCube_Root::getSingleton();
        $db =& $root->mController->mDB;
        
        $this->_save("-- SQL dump\n");
        
        foreach($this->_mTableName as $name)
        {
            if(!$res = $db->query(sprintf('select * from `%s`',$name)))
            {
                throw new Sd2nd_QueryException('Table "' . $name . '" is not readable.');
            }
            
            $cols = array();
            $type = array();
            for($i = 0;$i < $db->getFieldsNum($res);$i++)
            {
                $cols[] = $db->getFieldName($res,$i);
                $type[] = $db->getFieldType($res,$i);
            }
            
            $base = sprintf("insert delayed into `%s` (`%s`) values \n",$name,implode('`,`',$cols));
            $sql = array();
            $cnt = 0;
            while($row = $db->fetchArray($res))
            {
                $row = array_map(array($db,'quoteString'),$row);
                $sql[] = '(' . implode(',',$row) . ')';
                $cnt++;
                
                if($cnt >= self::MAX_INSERT_ROWS)
                {
                    $this->_save($base . implode(",\n",$sql) . ";\n");
                    $sql = array();
                    $cnt = 0;
                }
            }
            
            if(count($sql) > 0)
            {
                $this->_save($base . implode(",\n",$sql) . ";\n\n");
            }
        }
    }
    
    /**
     * _exportFooter
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    protected function _exportFooter()
    {
        $enable = array();
        $optimize = array();
        foreach($this->_mTableName as $name)
        {
            $enable[] = 'ALTER TABLE `' . $name . '` ENABLE KEYS;';
            $optimize[] = '`' . $name . "`";
        }
        
        $this->_save("-- enable keys\n" . implode("\n",$enable) . "\n\n-- optimize tables\nOPTIMIZE TABLE \n" . implode(",\n",$optimize) . "\n");
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_QueryException
    **/
    public function executeLatest()
    {
        $this->_mTableName = array(
            Sd2nd_AssetManager::HANDLER_ABILITY,
            Sd2nd_AssetManager::HANDLER_ACTIVE_ABILITY,
            Sd2nd_AssetManager::HANDLER_CHAR,
            Sd2nd_AssetManager::HANDLER_COSTUME,
            Sd2nd_AssetManager::HANDLER_ENO_PNO_LINK,
            Sd2nd_AssetManager::HANDLER_ICON,
            Sd2nd_AssetManager::HANDLER_IMAGE,
            Sd2nd_AssetManager::HANDLER_KIND,
            Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY,
            Sd2nd_AssetManager::HANDLER_LEARNED_COSTUME,
            Sd2nd_AssetManager::HANDLER_LEARNED_SKILL,
            Sd2nd_AssetManager::HANDLER_MAP,
            Sd2nd_AssetManager::HANDLER_MAP_CACHE,
            Sd2nd_AssetManager::HANDLER_MAP_NAME,
            Sd2nd_AssetManager::HANDLER_MAP_SPOT,
            Sd2nd_AssetManager::HANDLER_RACE,
            Sd2nd_AssetManager::HANDLER_SKILL,
            Sd2nd_AssetManager::HANDLER_SKILL_ELEMENT_LINK,
            Sd2nd_AssetManager::HANDLER_STATUS,
            Sd2nd_AssetManager::HANDLER_TARGET,
            Sd2nd_AssetManager::HANDLER_UPDATE
        );
        $this->_export();
    }
}

?>
