<?php
/**
 * @file
 * @package Sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_GarbageCollectionDispose
**/
class Sd2nd_GarbageCollectionDispose extends Sd2nd_AbstractFilter
{
    /**
     * @brief   Enum
    **/
    const ACTIVE_TABLE = Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY;
    
    /**
     * @brief   Enum
    **/
    const CHAR_TABLE = Sd2nd_AssetManager::HANDLER_CHAR;
    
    /**
     * @brief   string[]
    **/
    protected $_mTableName = array();
    
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_FIRST;
    }
    
    /**
     * _executeGC
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_QueryException
    **/
    protected function _executeGC()
    {
        $root =& XCube_Root::getSingleton();
        $db =& $root->mController->mDB;
        
        if(!$res = $db->query('select `m`.`eno` as `eno` from `' . Sd2nd_UpdateUtils::convertTableName(self::ACTIVE_TABLE) . '` as m left join `' . Sd2nd_UpdateUtils::convertTableName(self::CHAR_TABLE) . '` as c on `m`.`eno` = `c`.`eno` where isnull(`c`.`full_name`) group by `m`.`eno`'))
        {
            throw new Sd2nd_QueryException(array('active' => self::ACTIVE_TABLE,'char' => self::CHAR_TABLE));
        }
        
        $cri = new CriteriaCompo();
        while($row = $db->fetchArray($res))
        {
            $cri->add(new Criteria('eno',$row['eno']));
        }
        
        if($cri->hasChildElements())
        {
            foreach($this->_mTableName as $type)
            {
                Sd2nd_UpdateUtils::deleteMultiObjects($type,$cri);
            }
        }
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_QueryException
    **/
    public function executeLatest()
    {
        $this->_mTableName = array(
            Sd2nd_AssetManager::HANDLER_ICON,
            Sd2nd_AssetManager::HANDLER_IMAGE,
            Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY,
            Sd2nd_AssetManager::HANDLER_LEARNED_COSTUME,
            Sd2nd_AssetManager::HANDLER_LEARNED_SKILL
        );
        
        $this->_executeGC();
    }
}

?>
