<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_Icon_DataCharParser
**/
class Sd2nd_Icon_DataCharParser extends Sd2nd_AbstractParser
{
    protected /*** Sd2nd_IconHandler ***/ $_mHandler = null;
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        parent::__construct();
        $this->_mHandler =& Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_ICON);
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        try
        {
            $arr = Sd2nd_UpdateUtils::parseByRegex($this->_mLine,'/Icon_Data\[(?P<slot>\d+)\] = new TableData_Set\("(?P<icon_url>.+)",(?P<icon_width>\d+),(?P<icon_height>\d+)\)/');
        }
        catch(Exception $ex)
        {
            return;
        }
        $obj =& $this->_mHandler->getByUnique($this->_mActiveId,$arr['slot']);
        if(!$obj instanceof $this->_mHandler->mClass || $obj->get('icon_url') != $arr['icon_url'] || $obj->get('icon_width') != $arr['icon_width'] || $obj->get('icon_height') != $arr['icon_height'])
        {
            $this->_appendIcon($arr);
        }
    }
    
    /**
     * _appendIcon
     * 
     * @param   mixed{} $params
     * 
     * @return  void
    **/
    protected function _appendIcon(/*** mixed{} ***/ $params)
    {
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_ICON);
        $obj->set('eno',$this->_mActiveId);
        $obj->set('slot',$params['slot']);
        $obj->set('icon_url',$params['icon_url']);
        $obj->set('icon_height',$params['icon_height']);
        $obj->set('icon_width',$params['icon_width']);
        $obj->set('update_time',$this->_mUpdateTime);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_ICON,$obj);
    }
}


?>
