<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_Show_MapCharParser
**/
class Sd2nd_Show_MapCharParser extends Sd2nd_AbstractParser
{
    const /*** int ***/ BASE_SPOT = 3;
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        static $attr = null;
        $x = 0;
        $y = 0;
        $maps = array();
        $arr = explode(',',substr($this->_mLine,9,-1));
        list($name,$flag,$width,$point) = array_splice($arr,0,4);
        $name = trim($name,"'");
        $len = count($arr);
        if($attr == null)
        {
            $attr =& XCube_Root::getSingleton()->mContext->mAttributes;
        }
        $baseSpot = $attr['sd2nd.mapName'][$name]->get('base_spot');
        /// @todo
        if($baseSpot != 3)
        {
            return;
        }
        for($i = 0;$i < $len;$i += 2)
        {
            $key = $i >> 1;
            $maps[] = ($id = $this->_mExecute->mSpots[$arr[$i]]);
            if($id == $baseSpot)
            {
                $x = - ($key % $width);
                $y = - intval($key / $width);
            }
        }
        $attr['sd2nd.mapCollection'][$name]->addBySpotList($x,$y,array_chunk($maps,$width));
    }
    
    /**
     * execute090211
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute090211()
    {
        static $map = null;
        $x = 0;
        $y = 0;
        $maps = array();
        $arr = explode(',',substr($this->_mLine,9,-1));
        list($name,$flag,$width,$point) = array_splice($arr,0,4);
        $len = count($arr);
        for($i = 0;$i < $len;$i += 2)
        {
            $key = $i >> 1;
            $maps[] = ($id = $this->_mExecute->mSpots[$arr[$i]]);
            if($id == self::BASE_SPOT)
            {
                $x = - ($key % $width);
                $y = - intval($key / $width);
            }
        }
        if($map == null)
        {
            $map =& XCube_Root::getSingleton()->mContext->mAttributes['sd2nd.mapCollection'];
        }
        $map->addBySpotList($x,$y,array_chunk($maps,$width));
    }
    
    /**
     * execute090128
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute090128()
    {
        static $map = null;
        $x = 0;
        $y = 0;
        $maps = array();
        $arr = explode(',',substr($this->_mLine,9,-1));
        list($flag,$width,$point) = array_splice($arr,0,3);
        $len = count($arr);
        for($i = 0;$i < $len;$i += 2)
        {
            $key = $i >> 1;
            $maps[] = ($id = $this->_mExecute->mSpots[$arr[$i]]);
            if($id == self::BASE_SPOT)
            {
                $x = - ($key % $width);
                $y = - intval($key / $width);
            }
        }
        if($map == null)
        {
            $map =& XCube_Root::getSingleton()->mContext->mAttributes['sd2nd.mapCollection'];
        }
        $map->addBySpotList($x,$y,array_chunk($maps,$width));
    }
    
    /**
     * execute090107
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute090107()
    {
        static $map = null;
        $x = 0;
        $y = 0;
        $maps = array();
        $arr = explode(',',substr($this->_mLine,9,-1));
        list($flag,$width,$point) = array_splice($arr,0,3);
        foreach($arr as $i => $spot)
        {
            $maps[] = ($id = $this->_mExecute->mSpots[$spot]);
            if($id == self::BASE_SPOT)
            {
                $x = - ($i % $width);
                $y = - intval($i / $width);
            }
        }
        if($map == null)
        {
            $map =& XCube_Root::getSingleton()->mContext->mAttributes['sd2nd.mapCollection'];
        }
        $map->addBySpotList($x,$y,array_chunk($maps,$width));
    }
    
    /**
     * execute081217
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute081217()
    {
        $arr = Sd2nd_UpdateUtils::parseByExplode($this->_mLine,82,9,-1);
        $flag = array_shift($arr);
        
        foreach($arr as $spot)
        {
            $this->_mExecute->mMaps[] = $this->_mExecute->mSpots[$spot];
        }
    }
}


?>
