<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_RefleshTablePrepare
**/
class Sd2nd_RefleshTablePrepare extends Sd2nd_AbstractFilter
{
    protected /*** Enum[] ***/ $_mRegistTableName = array();
    protected /*** Enum[] ***/ $_mUpdateTableName = array();
    protected /*** Enum[] ***/ $_mTruncateTableName = array();
    
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_9;
    }
    
    /**
     * _reflesh
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_QueryException
    **/
    protected function _reflesh()
    {
        $root =& XCube_Root::getSingleton();
        $db =& $root->mController->mDB;
        
        $arr = array_map(array('Sd2nd_UpdateUtils','convertTableName'),$this->_mRegistTableName);
        foreach($arr as $table)
        {
            if(!$db->queryF('delete from `' . $table . '` where `regist_time` >= ' . SD2ND_UPDATE_TIME))
            {
                throw new Sd2nd_QueryException('Table "' . $table . '" cannot reflesh.');
            }
        }
        
        $arr = array_map(array('Sd2nd_UpdateUtils','convertTableName'),$this->_mUpdateTableName);
        foreach($arr as $table)
        {
            if(!$db->queryF('delete from `' . $table .'` where `update_time` >= ' . SD2ND_UPDATE_TIME))
            {
                throw new Sd2nd_QueryException('Table "' . $table . '" cannot reflesh.');
            }
        }
        
        $arr = array_map(array('Sd2nd_UpdateUtils','convertTableName'),$this->_mTruncateTableName);
        foreach($arr as $table)
        {
            if(!$db->queryF('truncate `' . $table . '`'))
            {
                throw new Sd2nd_QueryException('Table "' . $table . '" cannot truncate.');
            }
        }
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        /*
            Sd2nd_AssetManager::HANDLER_SKILL_ELEMENT_LINK,
        */
        $this->_mRegistTableName = array(
            Sd2nd_AssetManager::HANDLER_ABILITY,
            Sd2nd_AssetManager::HANDLER_COSTUME,
            Sd2nd_AssetManager::HANDLER_ENO_PNO_LINK,
            Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY,
            Sd2nd_AssetManager::HANDLER_LEARNED_COSTUME,
            Sd2nd_AssetManager::HANDLER_LEARNED_SKILL,
            Sd2nd_AssetManager::HANDLER_MAP_SPOT,
            Sd2nd_AssetManager::HANDLER_SKILL
        );
        
        $this->_mUpdateTableName = array(
            Sd2nd_AssetManager::HANDLER_ICON,
            Sd2nd_AssetManager::HANDLER_IMAGE,
            Sd2nd_AssetManager::HANDLER_MAP,
            Sd2nd_AssetManager::HANDLER_MAP_CACHE,
            Sd2nd_AssetManager::HANDLER_UPDATE
        );
        
        $this->_mTruncateTableName = array(
            Sd2nd_AssetManager::HANDLER_ACTIVE_ABILITY,
            Sd2nd_AssetManager::HANDLER_CHAR,
            Sd2nd_AssetManager::HANDLER_STATUS
        );
        
        $this->_reflesh();
    }
    
    /**
     * execute080524
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute080524()
    {
        $this->_mTruncateTableName = array(
            Sd2nd_AssetManager::HANDLER_ABILITY,
            Sd2nd_AssetManager::HANDLER_ACTIVE_ABILITY,
            Sd2nd_AssetManager::HANDLER_CHAR,
            Sd2nd_AssetManager::HANDLER_COSTUME,
            Sd2nd_AssetManager::HANDLER_ENO_PNO_LINK,
            Sd2nd_AssetManager::HANDLER_ICON,
            Sd2nd_AssetManager::HANDLER_IMAGE,
            Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY,
            Sd2nd_AssetManager::HANDLER_LEARNED_COSTUME,
            Sd2nd_AssetManager::HANDLER_LEARNED_SKILL,
            Sd2nd_AssetManager::HANDLER_MAP,
            Sd2nd_AssetManager::HANDLER_MAP_CACHE,
            Sd2nd_AssetManager::HANDLER_MAP_SPOT,
            Sd2nd_AssetManager::HANDLER_RACE,
            Sd2nd_AssetManager::HANDLER_SKILL,
            Sd2nd_AssetManager::HANDLER_SKILL_ELEMENT_LINK,
            Sd2nd_AssetManager::HANDLER_STATUS,
            Sd2nd_AssetManager::HANDLER_TARGET,
            Sd2nd_AssetManager::HANDLER_UPDATE
        );
        
        $this->_reflesh();
    }
}

?>
