<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD2ND_TRUST_PATH . '/class/AbstractFilterForm.class.php';

define('SD2ND_ABILITY_SORT_KEY_ABILITY_ID', 1);
define('SD2ND_ABILITY_SORT_KEY_ABILITY_NAME', 2);
define('SD2ND_ABILITY_SORT_KEY_DESCRIPTION', 3);
define('SD2ND_ABILITY_SORT_KEY_ABILITY_COST', 4);
define('SD2ND_ABILITY_SORT_KEY_REGIST_TIME', 5);
define('SD2ND_ABILITY_SORT_KEY_DEFAULT', SD2ND_ABILITY_SORT_KEY_ABILITY_ID);

/**
 * Sd2nd_AbilityFilterForm
**/
class Sd2nd_AbilityFilterForm extends Sd2nd_AbstractFilterForm
{
    /**
     * @var  string[]
     * 
     * @public
    **/
    var $mSortKeys = array(
        SD2ND_ABILITY_SORT_KEY_ABILITY_ID => 'ability_id',
        SD2ND_ABILITY_SORT_KEY_ABILITY_NAME => 'ability_name',
        SD2ND_ABILITY_SORT_KEY_DESCRIPTION => 'description',
        SD2ND_ABILITY_SORT_KEY_ABILITY_COST => 'ability_cost',
        SD2ND_ABILITY_SORT_KEY_REGIST_TIME => 'regist_time'
    );

    /**
     * getDefaultSortKey
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function getDefaultSortKey()
    {
        return SD2ND_ABILITY_SORT_KEY_DEFAULT;
    }

    /**
     * fetch
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function fetch()
    {
        parent::fetch();
    
        $request =& XCube_Root::getSingleton()->mContext->mRequest;
    
        if (($value = $request->getRequest('regist_time')) != null) {
            $this->_mCriteria->add(new Criteria('regist_time', $value));
        }
        $this->mNavi->addExtra('regist_time', $value);
    
        if (ctype_digit($value = $request->getRequest('ability_cost'))) {
            $this->_mCriteria->add(new Criteria('ability_cost', $value));
        }
        else
        {
            $value = null;
        }
        $this->mNavi->addExtra('ability_cost', $value);
    
        $this->_mCriteria->addSort($this->getSort(), $this->getOrder());
    }
}

?>
